/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class HistoryCommands {
    private final WorldEdit worldEdit;

    public HistoryCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="undo", aliases={"/undo"}, desc="Undoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.undo", "worldedit.history.undo.self"})
    public void undo(Player player, LocalSession session, @Arg(desc="Number of undoes to perform", def={"1"}) int times, @Arg(name="player", desc="Undo this player's operations", def={""}) String playerName) throws WorldEditException {
        EditSession undone;
        times = Math.max(1, times);
        LocalSession undoSession = session;
        if (playerName != null) {
            player.checkPermission("worldedit.history.undo.other");
            undoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (undoSession == null) {
                player.printError((Component)TranslatableComponent.of((String)"worldedit.session.cant-find-session", (Component[])new Component[]{TextComponent.of((String)playerName)}));
                return;
            }
        }
        int timesUndone = 0;
        for (int i = 0; i < times && (undone = undoSession.undo(undoSession.getBlockBag(player), player)) != null; ++i) {
            ++timesUndone;
            this.worldEdit.flushBlockBag(player, undone);
        }
        if (timesUndone > 0) {
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.undo.undone", (Component[])new Component[]{TextComponent.of((int)timesUndone)}));
        } else {
            player.printError((Component)TranslatableComponent.of((String)"worldedit.undo.none"));
        }
    }

    @Command(name="redo", aliases={"/redo"}, desc="Redoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.redo", "worldedit.history.redo.self"})
    public void redo(Player player, LocalSession session, @Arg(desc="Number of redoes to perform", def={"1"}) int times, @Arg(name="player", desc="Redo this player's operations", def={""}) String playerName) throws WorldEditException {
        EditSession redone;
        times = Math.max(1, times);
        LocalSession redoSession = session;
        if (playerName != null) {
            player.checkPermission("worldedit.history.redo.other");
            redoSession = this.worldEdit.getSessionManager().findByName(playerName);
            if (redoSession == null) {
                player.printError((Component)TranslatableComponent.of((String)"worldedit.session.cant-find-session", (Component[])new Component[]{TextComponent.of((String)playerName)}));
                return;
            }
        }
        int timesRedone = 0;
        for (int i = 0; i < times && (redone = redoSession.redo(redoSession.getBlockBag(player), player)) != null; ++i) {
            ++timesRedone;
            this.worldEdit.flushBlockBag(player, redone);
        }
        if (timesRedone > 0) {
            player.printInfo((Component)TranslatableComponent.of((String)"worldedit.redo.redone", (Component[])new Component[]{TextComponent.of((int)timesRedone)}));
        } else {
            player.printError((Component)TranslatableComponent.of((String)"worldedit.redo.none"));
        }
    }

    @Command(name="clearhistory", aliases={"/clearhistory"}, desc="Clear your history")
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(Actor actor, LocalSession session) {
        session.clearHistory();
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.clearhistory.cleared"));
    }
}

