/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.HistoryCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class HistoryCommandsRegistration
implements CommandRegistration<HistoryCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private HistoryCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument timesPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"times"), (Component)TextComponent.of((String)"Number of undoes to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument playerNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"player"), (Component)TextComponent.of((String)"Undo this player's operations")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument timesPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"times"), (Component)TextComponent.of((String)"Number of redoes to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument playerNamePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"player"), (Component)TextComponent.of((String)"Redo this player's operations")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();

    private HistoryCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static HistoryCommandsRegistration builder() {
        return new HistoryCommandsRegistration();
    }

    public HistoryCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public HistoryCommandsRegistration containerInstance(HistoryCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public HistoryCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public HistoryCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("undo", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/undo"));
            b.description((Component)TextComponent.of((String)"Undoes the last action (from history)"));
            b.parts((Collection)ImmutableList.of((Object)this.timesPart, (Object)this.playerNamePart));
            b.action(this::cmd$undo);
            Method commandMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"undo", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("redo", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/redo"));
            b.description((Component)TextComponent.of((String)"Redoes the last action (from history)"));
            b.parts((Collection)ImmutableList.of((Object)this.timesPart2, (Object)this.playerNamePart2));
            b.action(this::cmd$redo);
            Method commandMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"redo", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clearhistory", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/clearhistory"));
            b.description((Component)TextComponent.of((String)"Clear your history"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$clearhistory);
            Method commandMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"clearHistory", (Class[])new Class[]{Actor.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$undo(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"undo", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.undo(this.extract$player(parameters), this.extract$session(parameters), this.extract$times(parameters), this.extract$playerName(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$redo(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"redo", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.redo(this.extract$player(parameters), this.extract$session(parameters), this.extract$times2(parameters), this.extract$playerName2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$clearhistory(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(HistoryCommands.class, (String)"clearHistory", (Class[])new Class[]{Actor.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clearHistory(this.extract$actor(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private int extract$times(CommandParameters parameters) {
        return (Integer)this.timesPart.value(parameters).asSingle(integer_Key);
    }

    private String extract$playerName(CommandParameters parameters) {
        return (String)this.playerNamePart.value(parameters).asSingle(string_Key);
    }

    private int extract$times2(CommandParameters parameters) {
        return (Integer)this.timesPart2.value(parameters).asSingle(integer_Key);
    }

    private String extract$playerName2(CommandParameters parameters) {
        return (String)this.playerNamePart2.value(parameters).asSingle(string_Key);
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }
}

