/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.FlattenedClipboardTransform;
import com.sk89q.worldedit.command.util.AsyncCommandBuilder;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.formatting.component.CodeFormat;
import com.sk89q.worldedit.util.formatting.component.ErrorFormat;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.component.SubtleFormat;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.exception.CommandException;
import org.enginehub.piston.exception.StopExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class SchematicCommands {
    private static final Logger log = LoggerFactory.getLogger(SchematicCommands.class);
    private final WorldEdit worldEdit;

    public SchematicCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="load", desc="Load a schematic into your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load"})
    public void load(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={"sponge"}) String formatName) throws FilenameException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        File f = this.worldEdit.getSafeOpenFile(actor, dir, filename, BuiltInClipboardFormat.SPONGE_SCHEMATIC.getPrimaryFileExtension(), ClipboardFormats.getFileExtensionArray());
        if (!f.exists()) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.load.does-not-exist", (Component[])new Component[]{TextComponent.of((String)filename)}));
            return;
        }
        ClipboardFormat format = ClipboardFormats.findByFile(f);
        if (format == null) {
            format = ClipboardFormats.findByAlias(formatName);
        }
        if (format == null) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.unknown-format", (Component[])new Component[]{TextComponent.of((String)formatName)}));
            return;
        }
        SchematicLoadTask task = new SchematicLoadTask(actor, f, format);
        AsyncCommandBuilder.wrap(task, actor).registerWithSupervisor(this.worldEdit.getSupervisor(), "Loading schematic " + filename).sendMessageAfterDelay((Component)TranslatableComponent.of((String)"worldedit.schematic.load.loading")).onSuccess(((TextComponent)TextComponent.of((String)filename, (TextColor)TextColor.GOLD).append((Component)TextComponent.of((String)" loaded. Paste it with ", (TextColor)TextColor.LIGHT_PURPLE))).append(CodeFormat.wrap("//paste").clickEvent(ClickEvent.of((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)"//paste"))), session::setClipboard).onFailure("Failed to load schematic", this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
    }

    @Command(name="save", desc="Save a schematic into your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save"})
    public void save(Actor actor, LocalSession session, @Arg(desc="File name.") String filename, @Arg(desc="Format name.", def={"sponge"}) String formatName, @Switch(name=102, desc="Overwrite an existing file.") boolean allowOverwrite) throws WorldEditException {
        File parent;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        ClipboardFormat format = ClipboardFormats.findByAlias(formatName);
        if (format == null) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.unknown-format", (Component[])new Component[]{TextComponent.of((String)formatName)}));
            return;
        }
        File f = this.worldEdit.getSafeSaveFile(actor, dir, filename, format.getPrimaryFileExtension(), new String[0]);
        boolean overwrite = f.exists();
        if (overwrite) {
            if (!actor.hasPermission("worldedit.schematic.delete")) {
                throw new StopExecutionException((Component)TextComponent.of((String)"That schematic already exists!"));
            }
            if (!allowOverwrite) {
                actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.save.already-exists"));
                return;
            }
        }
        if ((parent = f.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
            throw new StopExecutionException((Component)TranslatableComponent.of((String)"worldedit.schematic.save.failed-directory"));
        }
        ClipboardHolder holder = session.getClipboard();
        SchematicSaveTask task = new SchematicSaveTask(actor, f, format, holder, overwrite);
        AsyncCommandBuilder.wrap(task, actor).registerWithSupervisor(this.worldEdit.getSupervisor(), "Saving schematic " + filename).sendMessageAfterDelay((Component)TranslatableComponent.of((String)"worldedit.schematic.save.saving")).onSuccess(filename + " saved" + (overwrite ? " (overwriting previous file)." : "."), null).onFailure("Failed to save schematic", this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
    }

    @Command(name="delete", aliases={"d"}, desc="Delete a saved schematic")
    @CommandPermissions(value={"worldedit.schematic.delete"})
    public void delete(Actor actor, @Arg(desc="File name.") String filename) throws WorldEditException {
        File dir;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File f = this.worldEdit.getSafeOpenFile(actor instanceof Player ? (Player)actor : null, dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir), filename, "schematic", ClipboardFormats.getFileExtensionArray());
        if (!f.exists()) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.delete.does-not-exist", (Component[])new Component[]{TextComponent.of((String)filename)}));
            return;
        }
        if (!f.delete()) {
            actor.printError((Component)TranslatableComponent.of((String)"worldedit.schematic.delete.failed", (Component[])new Component[]{TextComponent.of((String)filename)}));
            return;
        }
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.schematic.delete.deleted", (Component[])new Component[]{TextComponent.of((String)filename)}));
        try {
            log.info(actor.getName() + " deleted " + f.getCanonicalPath());
        }
        catch (IOException e) {
            log.info(actor.getName() + " deleted " + f.getAbsolutePath());
        }
    }

    @Command(name="formats", aliases={"listformats", "f"}, desc="List available formats")
    @CommandPermissions(value={"worldedit.schematic.formats"})
    public void formats(Actor actor) {
        actor.printInfo((Component)TranslatableComponent.of((String)"worldedit.schematic.formats.title"));
        boolean first = true;
        for (ClipboardFormat format : ClipboardFormats.getAll()) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.getName()).append(": ");
            for (String lookupName : format.getAliases()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            first = true;
            actor.printInfo((Component)TextComponent.of((String)builder.toString()));
        }
    }

    @Command(name="list", aliases={"all", "ls"}, desc="List saved schematics", descFooter="Note: Format is not fully verified until loading.")
    @CommandPermissions(value={"worldedit.schematic.list"})
    public void list(Actor actor, @ArgFlag(name=112, desc="Page to view.", def={"1"}) int page, @Switch(name=100, desc="Sort by date, oldest first") boolean oldFirst, @Switch(name=110, desc="Sort by date, newest first") boolean newFirst) {
        int sortType;
        if (oldFirst && newFirst) {
            throw new StopExecutionException((Component)TextComponent.of((String)"Cannot sort by oldest and newest."));
        }
        String saveDir = this.worldEdit.getConfiguration().saveDir;
        int n = oldFirst ? -1 : (sortType = newFirst ? 1 : 0);
        String pageCommand = actor.isPlayer() ? "//schem list -p %page%" + (sortType == -1 ? " -d" : (sortType == 1 ? " -n" : "")) : null;
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, (Callable<Component>)new SchematicListTask(saveDir, sortType, page, pageCommand), (Component)SubtleFormat.wrap("(Please wait... gathering schematic list.)"));
    }

    private static List<File> allFiles(File root) {
        File[] files = root.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                List<File> subFiles = SchematicCommands.allFiles(f);
                if (subFiles == null) continue;
                fileList.addAll(subFiles);
                continue;
            }
            fileList.add(f);
        }
        return fileList;
    }

    private static class SchematicPaginationBox
    extends PaginationBox {
        private final String prefix;
        private final File[] files;

        SchematicPaginationBox(String rootDir, File[] files, String pageCommand) {
            super("Available schematics", pageCommand);
            this.prefix = rootDir == null ? "" : rootDir;
            this.files = files;
        }

        @Override
        public Component getComponent(int number) {
            Preconditions.checkArgument((number < this.files.length && number >= 0 ? 1 : 0) != 0);
            File file = this.files[number];
            Multimap<String, ClipboardFormat> exts = ClipboardFormats.getFileExtensionMap();
            String format = exts.get((Object)Files.getFileExtension((String)file.getName())).stream().findFirst().map(ClipboardFormat::getName).orElse("Unknown");
            boolean inRoot = file.getParentFile().getName().equals(this.prefix);
            String path = inRoot ? file.getName() : file.getPath().split(Pattern.quote(this.prefix + File.separator))[1];
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().content("").append(((TextComponent)((TextComponent)TextComponent.of((String)"[L]").color(TextColor.GOLD)).clickEvent(ClickEvent.of((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/schem load \"" + path + "\"")))).hoverEvent(HoverEvent.of((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)"Click to load"))))).append((Component)TextComponent.space())).append(((TextComponent)TextComponent.of((String)path).color(TextColor.DARK_GREEN)).hoverEvent(HoverEvent.of((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Component)TextComponent.of((String)format))))).build();
        }

        @Override
        public int getComponentsSize() {
            return this.files.length;
        }
    }

    private static class SchematicListTask
    implements Callable<Component> {
        private final String prefix;
        private final int sortType;
        private final int page;
        private final File rootDir;
        private final String pageCommand;

        SchematicListTask(String prefix, int sortType, int page, String pageCommand) {
            this.prefix = prefix;
            this.sortType = sortType;
            this.page = page;
            this.rootDir = WorldEdit.getInstance().getWorkingDirectoryFile(prefix);
            this.pageCommand = pageCommand;
        }

        @Override
        public Component call() throws Exception {
            List fileList = SchematicCommands.allFiles(this.rootDir);
            if (fileList == null || fileList.isEmpty()) {
                return ErrorFormat.wrap("No schematics found.");
            }
            File[] files = new File[fileList.size()];
            fileList.toArray(files);
            Arrays.sort(files, (f1, f2) -> {
                int res;
                if (this.sortType == 0) {
                    int p = f1.getParent().compareTo(f2.getParent());
                    res = p == 0 ? f1.getName().compareTo(f2.getName()) : p;
                } else {
                    res = Long.compare(f1.lastModified(), f2.lastModified());
                    if (this.sortType == 1) {
                        res = -res;
                    }
                }
                return res;
            });
            SchematicPaginationBox paginationBox = new SchematicPaginationBox(this.prefix, files, this.pageCommand);
            return paginationBox.create(this.page);
        }
    }

    private static class SchematicSaveTask
    implements Callable<Void> {
        private final Actor actor;
        private final File file;
        private final ClipboardFormat format;
        private final ClipboardHolder holder;
        private final boolean overwrite;

        SchematicSaveTask(Actor actor, File file, ClipboardFormat format, ClipboardHolder holder, boolean overwrite) {
            this.actor = actor;
            this.file = file;
            this.format = format;
            this.holder = holder;
            this.overwrite = overwrite;
        }

        @Override
        public Void call() throws Exception {
            Clipboard target;
            Clipboard clipboard = this.holder.getClipboard();
            Transform transform = this.holder.getTransform();
            if (transform.isIdentity()) {
                target = clipboard;
            } else {
                FlattenedClipboardTransform result = FlattenedClipboardTransform.transform(clipboard, transform);
                target = new BlockArrayClipboard(result.getTransformedRegion());
                target.setOrigin(clipboard.getOrigin());
                Operations.completeLegacy(result.copyTo(target));
            }
            try (Closer closer = Closer.create();){
                FileOutputStream fos = closer.register(new FileOutputStream(this.file));
                BufferedOutputStream bos = closer.register(new BufferedOutputStream(fos));
                ClipboardWriter writer = closer.register(this.format.getWriter(bos));
                writer.write(target);
                log.info(this.actor.getName() + " saved " + this.file.getCanonicalPath() + (this.overwrite ? " (overwriting previous file)" : ""));
            }
            catch (IOException e) {
                this.file.delete();
                throw new CommandException((Component)TextComponent.of((String)e.getMessage()), (Throwable)e, ImmutableList.of());
            }
            return null;
        }
    }

    private static class SchematicLoadTask
    implements Callable<ClipboardHolder> {
        private final Actor actor;
        private final File file;
        private final ClipboardFormat format;

        SchematicLoadTask(Actor actor, File file, ClipboardFormat format) {
            this.actor = actor;
            this.file = file;
            this.format = format;
        }

        @Override
        public ClipboardHolder call() throws Exception {
            try (Closer closer = Closer.create();){
                FileInputStream fis = closer.register(new FileInputStream(this.file));
                BufferedInputStream bis = closer.register(new BufferedInputStream(fis));
                ClipboardReader reader = closer.register(this.format.getReader(bis));
                Clipboard clipboard = reader.read();
                log.info(this.actor.getName() + " loaded " + this.file.getCanonicalPath());
                ClipboardHolder clipboardHolder = new ClipboardHolder(clipboard);
                return clipboardHolder;
            }
        }
    }
}

