/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.BannerBlockCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.BedBlockCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.EntityNBTCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.FlowerPotCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NoteBlockCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.Pre13HangingCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.SignCompatibilityHandler;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.SkullBlockCompatibilityHandler;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.storage.NBTConversions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCEditSchematicReader
extends NBTSchematicReader {
    private static final Logger log = LoggerFactory.getLogger(MCEditSchematicReader.class);
    private final NBTInputStream inputStream;
    private final DataFixer fixer;
    private static final ImmutableList<NBTCompatibilityHandler> COMPATIBILITY_HANDLERS = ImmutableList.of((Object)new SignCompatibilityHandler(), (Object)new FlowerPotCompatibilityHandler(), (Object)new NoteBlockCompatibilityHandler(), (Object)new SkullBlockCompatibilityHandler(), (Object)new BannerBlockCompatibilityHandler(), (Object)new BedBlockCompatibilityHandler());
    private static final ImmutableList<EntityNBTCompatibilityHandler> ENTITY_COMPATIBILITY_HANDLERS = ImmutableList.of((Object)new Pre13HangingCompatibilityHandler());

    public MCEditSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
        this.fixer = null;
    }

    @Override
    public Clipboard read() throws IOException {
        CuboidRegion region;
        BlockVector3 origin;
        NamedTag rootTag = this.inputStream.readNamedTag();
        if (!rootTag.getName().equals("Schematic")) {
            throw new IOException("Tag 'Schematic' does not exist or is not first");
        }
        CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
        Object schematic = schematicTag.getValue();
        if (!schematic.containsKey("Blocks")) {
            throw new IOException("Schematic file is missing a 'Blocks' tag");
        }
        String materials = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
        if (!materials.equals("Alpha")) {
            throw new IOException("Schematic file is not an Alpha schematic");
        }
        int width = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
        int height = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
        int length = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
        try {
            int originX = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
            int originY = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
            int originZ = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            BlockVector3 min = BlockVector3.at(originX, originY, originZ);
            int offsetX = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetX", IntTag.class).getValue();
            int offsetY = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "WEOffsetZ", IntTag.class).getValue();
            BlockVector3 offset = BlockVector3.at(offsetX, offsetY, offsetZ);
            origin = min.subtract(offset);
            region = new CuboidRegion(min, min.add(width, height, length).subtract(BlockVector3.ONE));
        }
        catch (IOException ignored) {
            origin = BlockVector3.ZERO;
            region = new CuboidRegion(origin, origin.add(width, height, length).subtract(BlockVector3.ONE));
        }
        byte[] blockId = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
        byte[] blockData = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
        byte[] addId = new byte[]{};
        short[] blocks = new short[blockId.length];
        if (schematic.containsKey("AddBlocks")) {
            addId = MCEditSchematicReader.requireTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
        }
        for (int index = 0; index < blockId.length; ++index) {
            blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
        }
        ListTag tileEntityTag = MCEditSchematicReader.getTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class);
        Object tileEntities = tileEntityTag == null ? new ArrayList() : tileEntityTag.getValue();
        HashMap<BlockVector3, Object> tileEntitiesMap = new HashMap<BlockVector3, Object>();
        HashMap<BlockVector3, BlockState> blockStates = new HashMap<BlockVector3, BlockState>();
        Iterator iterator = tileEntities.iterator();
        while (iterator.hasNext()) {
            BlockState block;
            Tag tag = (Tag)iterator.next();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag t = (CompoundTag)tag;
            HashMap<String, Tag> values = new HashMap<String, Tag>((Map<String, Tag>)t.getValue());
            String id = t.getString("id");
            values.put("id", new StringTag(this.convertBlockEntityId(id)));
            int x = t.getInt("x");
            int y = t.getInt("y");
            int z = t.getInt("z");
            int index = y * width * length + z * width + x;
            BlockState newBlock = block = this.getBlockState(blocks[index], blockData[index]);
            if (newBlock != null) {
                NBTCompatibilityHandler handler;
                UnmodifiableIterator unmodifiableIterator = COMPATIBILITY_HANDLERS.iterator();
                while (unmodifiableIterator.hasNext() && (!(handler = (NBTCompatibilityHandler)unmodifiableIterator.next()).isAffectedBlock(newBlock) || (newBlock = handler.updateNBT(block, values)) != null && !values.isEmpty())) {
                }
            }
            t = values.isEmpty() ? null : new CompoundTag(values);
            if (this.fixer != null && t != null) {
                t = this.fixer.fixUp(DataFixer.FixTypes.BLOCK_ENTITY, t, -1);
            }
            BlockVector3 vec = BlockVector3.at(x, y, z);
            if (t != null) {
                tileEntitiesMap.put(vec, t.getValue());
            }
            blockStates.put(vec, newBlock);
        }
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        HashSet<Integer> unknownBlocks = new HashSet<Integer>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    BlockVector3 pt = BlockVector3.at(x, y, z);
                    BlockState state = blockStates.computeIfAbsent(pt, p -> this.getBlockState(blocks[index], blockData[index]));
                    try {
                        if (state != null) {
                            if (tileEntitiesMap.containsKey(pt)) {
                                clipboard.setBlock(region.getMinimumPoint().add(pt), state.toBaseBlock(new CompoundTag((Map)tileEntitiesMap.get(pt))));
                                continue;
                            }
                            clipboard.setBlock(region.getMinimumPoint().add(pt), state);
                            continue;
                        }
                        short block = blocks[index];
                        byte data = blockData[index];
                        int combined = block << 8 | data;
                        if (!unknownBlocks.add(combined)) continue;
                        log.warn("Unknown block when loading schematic: " + block + ":" + data + ". This is most likely a bad schematic.");
                        continue;
                    }
                    catch (WorldEditException block) {
                        // empty catch block
                    }
                }
            }
        }
        ListTag entityList = MCEditSchematicReader.getTag((Map<String, Tag>)schematic, "Entities", ListTag.class);
        if (entityList != null) {
            Object entityTags = entityList.getValue();
            Iterator iterator2 = entityTags.iterator();
            while (iterator2.hasNext()) {
                Tag tag = (Tag)iterator2.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compound = (CompoundTag)tag;
                if (this.fixer != null) {
                    compound = this.fixer.fixUp(DataFixer.FixTypes.ENTITY, compound, -1);
                }
                String id = this.convertEntityId(compound.getString("id"));
                Location location = NBTConversions.toLocation(clipboard, compound.getListTag("Pos"), compound.getListTag("Rotation"));
                if (id.isEmpty()) continue;
                EntityType entityType = EntityTypes.get(id.toLowerCase(Locale.ROOT));
                if (entityType != null) {
                    for (EntityNBTCompatibilityHandler compatibilityHandler : ENTITY_COMPATIBILITY_HANDLERS) {
                        if (!compatibilityHandler.isAffectedEntity(entityType, compound)) continue;
                        compound = compatibilityHandler.updateNBT(entityType, compound);
                    }
                    BaseEntity state = new BaseEntity(entityType, compound);
                    clipboard.createEntity(location, state);
                    continue;
                }
                log.warn("Unknown entity when pasting schematic: " + id.toLowerCase(Locale.ROOT));
            }
        }
        return clipboard;
    }

    private String convertEntityId(String id) {
        switch (id) {
            case "AreaEffectCloud": {
                return "area_effect_cloud";
            }
            case "ArmorStand": {
                return "armor_stand";
            }
            case "CaveSpider": {
                return "cave_spider";
            }
            case "MinecartChest": {
                return "chest_minecart";
            }
            case "DragonFireball": {
                return "dragon_fireball";
            }
            case "ThrownEgg": {
                return "egg";
            }
            case "EnderDragon": {
                return "ender_dragon";
            }
            case "ThrownEnderpearl": {
                return "ender_pearl";
            }
            case "FallingSand": {
                return "falling_block";
            }
            case "FireworksRocketEntity": {
                return "fireworks_rocket";
            }
            case "MinecartFurnace": {
                return "furnace_minecart";
            }
            case "MinecartHopper": {
                return "hopper_minecart";
            }
            case "EntityHorse": {
                return "horse";
            }
            case "ItemFrame": {
                return "item_frame";
            }
            case "LeashKnot": {
                return "leash_knot";
            }
            case "LightningBolt": {
                return "lightning_bolt";
            }
            case "LavaSlime": {
                return "magma_cube";
            }
            case "MinecartRideable": {
                return "minecart";
            }
            case "MushroomCow": {
                return "mooshroom";
            }
            case "Ozelot": {
                return "ocelot";
            }
            case "PolarBear": {
                return "polar_bear";
            }
            case "ThrownPotion": {
                return "potion";
            }
            case "ShulkerBullet": {
                return "shulker_bullet";
            }
            case "SmallFireball": {
                return "small_fireball";
            }
            case "MinecartSpawner": {
                return "spawner_minecart";
            }
            case "SpectralArrow": {
                return "spectral_arrow";
            }
            case "PrimedTnt": {
                return "tnt";
            }
            case "MinecartTNT": {
                return "tnt_minecart";
            }
            case "VillagerGolem": {
                return "villager_golem";
            }
            case "WitherBoss": {
                return "wither";
            }
            case "WitherSkull": {
                return "wither_skull";
            }
            case "PigZombie": {
                return "zombie_pigman";
            }
            case "XPOrb": 
            case "xp_orb": {
                return "experience_orb";
            }
            case "ThrownExpBottle": 
            case "xp_bottle": {
                return "experience_bottle";
            }
            case "EyeOfEnderSignal": 
            case "eye_of_ender_signal": {
                return "eye_of_ender";
            }
            case "EnderCrystal": 
            case "ender_crystal": {
                return "end_crystal";
            }
            case "fireworks_rocket": {
                return "firework_rocket";
            }
            case "MinecartCommandBlock": 
            case "commandblock_minecart": {
                return "command_block_minecart";
            }
            case "snowman": {
                return "snow_golem";
            }
            case "villager_golem": {
                return "iron_golem";
            }
            case "evocation_fangs": {
                return "evoker_fangs";
            }
            case "evocation_illager": {
                return "evoker";
            }
            case "vindication_illager": {
                return "vindicator";
            }
            case "illusion_illager": {
                return "illusioner";
            }
        }
        return id;
    }

    private String convertBlockEntityId(String id) {
        switch (id) {
            case "Cauldron": {
                return "brewing_stand";
            }
            case "Control": {
                return "command_block";
            }
            case "DLDetector": {
                return "daylight_detector";
            }
            case "Trap": {
                return "dispenser";
            }
            case "EnchantTable": {
                return "enchanting_table";
            }
            case "EndGateway": {
                return "end_gateway";
            }
            case "AirPortal": {
                return "end_portal";
            }
            case "EnderChest": {
                return "ender_chest";
            }
            case "FlowerPot": {
                return "flower_pot";
            }
            case "RecordPlayer": {
                return "jukebox";
            }
            case "MobSpawner": {
                return "mob_spawner";
            }
            case "Music": 
            case "noteblock": {
                return "note_block";
            }
            case "Structure": {
                return "structure_block";
            }
            case "Chest": {
                return "chest";
            }
            case "Sign": {
                return "sign";
            }
            case "Banner": {
                return "banner";
            }
            case "Beacon": {
                return "beacon";
            }
            case "Comparator": {
                return "comparator";
            }
            case "Dropper": {
                return "dropper";
            }
            case "Furnace": {
                return "furnace";
            }
            case "Hopper": {
                return "hopper";
            }
            case "Skull": {
                return "skull";
            }
        }
        return id;
    }

    private BlockState getBlockState(int id, int data) {
        return LegacyMapper.getInstance().getBlockFromLegacy(id, data);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

