/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;

public abstract class ArbitraryBiomeShape {
    private final Region extent;
    private final int cacheOffsetX;
    private final int cacheOffsetY;
    private final int cacheOffsetZ;
    private final int cacheSizeX;
    private final int cacheSizeY;
    private final int cacheSizeZ;
    private final BiomeType[] cache;

    public ArbitraryBiomeShape(Region extent) {
        this.extent = extent;
        BlockVector3 min = extent.getMinimumPoint();
        BlockVector3 max = extent.getMaximumPoint();
        this.cacheOffsetX = min.getBlockX() - 1;
        this.cacheOffsetY = min.getBlockY() - 1;
        this.cacheOffsetZ = min.getBlockZ() - 1;
        this.cacheSizeX = max.getX() - this.cacheOffsetX + 2;
        this.cacheSizeY = max.getY() - this.cacheOffsetY + 2;
        this.cacheSizeZ = max.getZ() - this.cacheOffsetZ + 2;
        this.cache = new BiomeType[this.cacheSizeX * this.cacheSizeY * this.cacheSizeZ];
    }

    protected Iterable<BlockVector3> getExtent() {
        return this.extent;
    }

    protected abstract BiomeType getBiome(int var1, int var2, int var3, BiomeType var4);

    private BiomeType getBiomeCached(int x, int y, int z, BiomeType baseBiome) {
        int index = y - this.cacheOffsetY + (z - this.cacheOffsetZ) * this.cacheSizeY + (x - this.cacheOffsetX) * this.cacheSizeY * this.cacheSizeZ;
        BiomeType cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            BiomeType material = this.getBiome(x, y, z, baseBiome);
            if (material == null) {
                this.cache[index] = null;
                return null;
            }
            this.cache[index] = material;
            return material;
        }
        return cacheEntry;
    }

    private boolean isInsideCached(int x, int y, int z, BiomeType baseBiome) {
        int index = y - this.cacheOffsetY + (z - this.cacheOffsetZ) * this.cacheSizeY + (x - this.cacheOffsetX) * this.cacheSizeY * this.cacheSizeZ;
        BiomeType cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            return this.getBiomeCached(x, y, z, baseBiome) != null;
        }
        return cacheEntry != BiomeTypes.THE_VOID;
    }

    public int generate(EditSession editSession, BiomeType baseBiome, boolean hollow) {
        int affected = 0;
        for (BlockVector3 position : this.getExtent()) {
            BiomeType material;
            int x = position.getBlockX();
            int y = position.getBlockY();
            int z = position.getBlockZ();
            if (!hollow) {
                material = this.getBiome(x, y, z, baseBiome);
                if (material == null || material == BiomeTypes.THE_VOID) continue;
                editSession.getWorld().setBiome(position, material);
                ++affected;
                continue;
            }
            material = this.getBiomeCached(x, y, z, baseBiome);
            if (material == null) continue;
            boolean draw = false;
            if (!this.isInsideCached(x + 1, y, z, material)) {
                draw = true;
            } else if (!this.isInsideCached(x - 1, y, z, material)) {
                draw = true;
            } else if (!this.isInsideCached(x, y, z + 1, material)) {
                draw = true;
            } else if (!this.isInsideCached(x, y, z - 1, material)) {
                draw = true;
            } else if (!this.isInsideCached(x, y + 1, z, material)) {
                draw = true;
            } else if (!this.isInsideCached(x, y - 1, z, material)) {
                draw = true;
            }
            if (!draw) continue;
            editSession.getWorld().setBiome(position, material);
            ++affected;
        }
        return affected;
    }
}

