/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SafeFiles {
    public static Stream<Path> noLeakFileList(Path dir) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            Stream<Path> stream2 = stream.collect(Collectors.toList()).stream();
            return stream2;
        }
    }

    public static String canonicalFileName(Path path) {
        return SafeFiles.dropSlash(path.getFileName().toString());
    }

    private static String dropSlash(String name) {
        if (name.isEmpty() || name.codePointBefore(name.length()) != 47) {
            return name;
        }
        return name.substring(0, name.length() - 1);
    }

    private SafeFiles() {
    }
}

