/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class BlockState
implements BlockStateHolder<BlockState> {
    private final BlockType blockType;
    private final Map<Property<?>, Object> values;
    private BaseBlock emptyBaseBlock;
    private Table<Property<?>, Object, BlockState> states;
    private int internalId = BlockStateIdAccess.invalidId();
    private Integer hashCodeCache = null;

    BlockState(BlockType blockType) {
        this.blockType = blockType;
        this.values = new LinkedHashMap();
        this.emptyBaseBlock = new BaseBlock(this);
    }

    static Map<Map<Property<?>, Object>, BlockState> generateStateMap(BlockType blockType) {
        LinkedHashMap stateMap = new LinkedHashMap();
        List<Property<?>> properties = blockType.getProperties();
        if (!properties.isEmpty()) {
            ArrayList separatedValues = Lists.newArrayList();
            for (Property<?> prop : properties) {
                ArrayList vals = Lists.newArrayList();
                vals.addAll(prop.getValues());
                separatedValues.add(vals);
            }
            List valueLists = Lists.cartesianProduct((List)separatedValues);
            for (List valueList : valueLists) {
                TreeMap valueMap = Maps.newTreeMap(Comparator.comparing(Property::getName));
                BlockState stateMaker = new BlockState(blockType);
                for (int i = 0; i < valueList.size(); ++i) {
                    Property<?> property = properties.get(i);
                    Object value = valueList.get(i);
                    valueMap.put(property, value);
                    stateMaker.setState(property, value);
                }
                stateMap.put(valueMap, stateMaker);
            }
        }
        if (stateMap.isEmpty()) {
            stateMap.put(new LinkedHashMap(), new BlockState(blockType));
        }
        for (BlockState state : stateMap.values()) {
            state.populate(stateMap);
        }
        return stateMap;
    }

    private void populate(Map<Map<Property<?>, Object>, BlockState> stateMap) {
        HashBasedTable states = HashBasedTable.create();
        for (Map.Entry<Property<?>, Object> entry : this.values.entrySet()) {
            Property<?> property = entry.getKey();
            property.getValues().forEach(arg_0 -> this.lambda$populate$0(entry, stateMap, property, (Table)states, arg_0));
        }
        this.states = states.isEmpty() ? states : ArrayTable.create((Table)states);
    }

    private <V> Map<Property<?>, Object> withValue(Property<V> property, V value) {
        HashMap values = Maps.newHashMap(this.values);
        values.put(property, value);
        return values;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    @Override
    public <V> BlockState with(Property<V> property, V value) {
        BlockState result = (BlockState)this.states.get(property, value);
        return result == null ? this : result;
    }

    @Override
    public <V> V getState(Property<V> property) {
        return (V)this.values.get(property);
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.getBlockType().equals(o.getBlockType())) {
            return false;
        }
        HashSet differingProperties = new HashSet();
        for (Property<?> state : o.getStates().keySet()) {
            if (this.getState(state) != null) continue;
            differingProperties.add(state);
        }
        for (Property<?> property : this.getStates().keySet()) {
            if (o.getState(property) != null) continue;
            differingProperties.add(property);
        }
        for (Property<?> property : this.getStates().keySet()) {
            if (differingProperties.contains(property) || Objects.equals(this.getState(property), o.getState(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState toImmutableState() {
        return this;
    }

    @Override
    public BaseBlock toBaseBlock() {
        return this.emptyBaseBlock;
    }

    @Override
    public BaseBlock toBaseBlock(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return this.toBaseBlock();
        }
        return new BaseBlock(this, compoundTag);
    }

    BlockState setState(Property<?> property, Object value) {
        this.values.put(property, value);
        return this;
    }

    public String toString() {
        return this.getAsString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockState)) {
            return false;
        }
        return this.equalsFuzzy((BlockState)obj);
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = Objects.hash(this.blockType, this.values);
        }
        return this.hashCodeCache;
    }

    private /* synthetic */ void lambda$populate$0(Map.Entry entry, Map stateMap, Property property, Table states, Object value) {
        if (value != entry.getValue()) {
            BlockState modifiedState = (BlockState)stateMap.get(this.withValue(property, value));
            if (modifiedState != null) {
                states.put((Object)property, value, (Object)modifiedState);
            } else {
                System.out.println(stateMap);
                WorldEdit.logger.warn("Found a null state at " + this.withValue(property, value));
            }
        }
    }

    static {
        BlockStateIdAccess.setBlockStateInternalId(new BlockStateIdAccess.BlockStateInternalId(){

            @Override
            public int getInternalId(BlockState blockState) {
                return blockState.internalId;
            }

            @Override
            public void setInternalId(BlockState blockState, int internalId) {
                blockState.internalId = internalId;
            }
        });
    }
}

