/*
 * WorldEdit, a Minecraft world manipulation toolkit
 * Copyright (C) sk89q <http://www.sk89q.com>
 * Copyright (C) WorldEdit team and contributors
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.sk89q.worldedit.forge.gui;

import com.sk89q.worldedit.forge.ForgeWorldEdit;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiReferenceCard extends GuiScreen {

    private GuiButton closeButton;
    private int backgroundWidth = 256;
    private int backgroundHeight = 256;

    @Override
    public void func_73866_w_() {
        this.field_146292_n.add(this.closeButton = new GuiButton(0, (this.field_146294_l - this.backgroundWidth + 100) / 2, (this.field_146295_m + this.backgroundHeight - 60) / 2, this.backgroundWidth - 100, 20, "Close"));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        int x = (this.field_146294_l - this.backgroundWidth) / 2;
        int y = (this.field_146295_m - this.backgroundHeight) / 2 - this.closeButton.field_146121_g;

        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation(ForgeWorldEdit.MOD_ID, "textures/gui/reference.png"));
        this.func_73729_b(x, y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        super.func_73863_a(mouseX, mouseY, par3);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    @Override
    public boolean func_73868_f() {
        return true;
    }

}
