/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.util.Direction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

final class ForgeAdapter {
    private ForgeAdapter() {
    }

    public static com.sk89q.worldedit.world.World adapt(World world) {
        return new ForgeWorld(world);
    }

    public static Vector adapt(Vec3d vector) {
        return new Vector(vector.x, vector.y, vector.z);
    }

    public static Vector adapt(BlockPos pos) {
        return new Vector(pos.getX(), pos.getY(), pos.getZ());
    }

    public static Vec3d toVec3(Vector vector) {
        return new Vec3d((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static EnumFacing adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case DOWN: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.UP;
    }

    public static BlockPos toBlockPos(Vector vector) {
        return new BlockPos(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }
}

