/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ForgeEntityProperties
implements EntityProperties {
    private final Entity entity;

    public ForgeEntityProperties(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
    }

    public boolean isPlayerDerived() {
        return this.entity instanceof EntityPlayer;
    }

    public boolean isProjectile() {
        return this.entity instanceof EntityEnderEye || this.entity instanceof IProjectile;
    }

    public boolean isItem() {
        return this.entity instanceof EntityItem;
    }

    public boolean isFallingBlock() {
        return this.entity instanceof EntityFallingBlock;
    }

    public boolean isPainting() {
        return this.entity instanceof EntityPainting;
    }

    public boolean isItemFrame() {
        return this.entity instanceof EntityItemFrame;
    }

    public boolean isBoat() {
        return this.entity instanceof EntityBoat;
    }

    public boolean isMinecart() {
        return this.entity instanceof EntityMinecart;
    }

    public boolean isTNT() {
        return this.entity instanceof EntityTNTPrimed;
    }

    public boolean isExperienceOrb() {
        return this.entity instanceof EntityXPOrb;
    }

    public boolean isLiving() {
        return this.entity instanceof EntityLiving;
    }

    public boolean isAnimal() {
        return this.entity instanceof EntityAnimal;
    }

    public boolean isAmbient() {
        return this.entity instanceof EntityAmbientCreature;
    }

    public boolean isNPC() {
        return this.entity instanceof INpc || this.entity instanceof IMerchant;
    }

    public boolean isGolem() {
        return this.entity instanceof EntityGolem;
    }

    public boolean isTamed() {
        return this.entity instanceof EntityTameable && ((EntityTameable)this.entity).isTamed();
    }

    public boolean isTagged() {
        return this.entity instanceof EntityLiving && ((EntityLiving)this.entity).hasCustomName();
    }

    public boolean isArmorStand() {
        return this.entity instanceof EntityArmorStand;
    }

    public boolean isPasteable() {
        return !(this.entity instanceof EntityPlayerMP) && !(this.entity instanceof MultiPartEntityPart);
    }
}

