/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.forge.CommandWrapper;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeRegistries;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.world.registry.Registries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

class ForgePlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final ForgeWorldEdit mod;
    private final MinecraftServer server;
    private boolean hookingEvents = false;

    ForgePlatform(ForgeWorldEdit mod) {
        this.mod = mod;
        this.server = FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    public Registries getRegistries() {
        return ForgeRegistries.getInstance();
    }

    public boolean isValidMobType(String type) {
        return EntityList.isRegistered((ResourceLocation)new ResourceLocation(type));
    }

    public void reload() {
        this.getConfiguration().load();
    }

    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    public List<? extends com.sk89q.worldedit.world.World> getWorlds() {
        WorldServer[] worlds = DimensionManager.getWorlds();
        ArrayList<ForgeWorld> ret = new ArrayList<ForgeWorld>(worlds.length);
        for (WorldServer world : worlds) {
            ret.add(new ForgeWorld((World)world));
        }
        return ret;
    }

    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof ForgePlayer) {
            return player;
        }
        EntityPlayerMP entity = this.server.getPlayerList().getPlayerByUsername(player.getName());
        return entity != null ? new ForgePlayer(entity) : null;
    }

    @Nullable
    public com.sk89q.worldedit.world.World matchWorld(com.sk89q.worldedit.world.World world) {
        if (world instanceof ForgeWorld) {
            return world;
        }
        for (WorldServer ws : DimensionManager.getWorlds()) {
            if (!ws.getWorldInfo().getWorldName().equals(world.getName())) continue;
            return new ForgeWorld((World)ws);
        }
        return null;
    }

    public void registerCommands(Dispatcher dispatcher) {
        if (this.server == null) {
            return;
        }
        ServerCommandManager mcMan = (ServerCommandManager)this.server.getCommandManager();
        for (CommandMapping command : dispatcher.getCommands()) {
            CommandWrapper wrapper = new CommandWrapper(command);
            mcMan.registerCommand((ICommand)wrapper);
            if (command.getDescription().getPermissions().size() <= 0) continue;
            ForgeWorldEdit.inst.getPermissionsProvider().registerPermission((ICommand)wrapper, (String)command.getDescription().getPermissions().get(0));
            for (int i = 1; i < command.getDescription().getPermissions().size(); ++i) {
                ForgeWorldEdit.inst.getPermissionsProvider().registerPermission(null, (String)command.getDescription().getPermissions().get(i));
            }
        }
    }

    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    public ForgeConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    public String getPlatformName() {
        return "Forge-Official";
    }

    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        PlayerList scm = this.server.getPlayerList();
        for (EntityPlayerMP entity : scm.getPlayers()) {
            if (entity == null) continue;
            users.add((Actor)new ForgePlayer(entity));
        }
        return users;
    }
}

