/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.WECUIPacketHandler;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgePlayer
extends AbstractPlayerActor {
    private final EntityPlayerMP player;

    protected ForgePlayer(EntityPlayerMP player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    public UUID getUniqueId() {
        return this.player.getUniqueID();
    }

    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack is = this.player.getHeldItem(handSide == HandSide.MAIN_HAND ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        return new BaseItemStack(ItemTypes.get((String)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)is.getItem()).toString()));
    }

    public String getName() {
        return this.player.getName();
    }

    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    public Location getLocation() {
        Vector position = new Vector(this.player.posX, this.player.posY, this.player.posZ);
        return new Location((Extent)ForgeWorldEdit.inst.getWorld(this.player.world), position, this.player.rotationYaw, this.player.rotationPitch);
    }

    public World getWorld() {
        return ForgeWorldEdit.inst.getWorld(this.player.world);
    }

    public void giveItem(BaseItemStack itemStack) {
        this.player.inventory.addItemStackToInventory(new ItemStack(Item.getByNameOrId((String)itemStack.getType().getId()), itemStack.getAmount(), 0));
    }

    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString((String[])params, (String)"|");
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((byte[])send.getBytes(WECUIPacketHandler.UTF_8_CHARSET)));
        SPacketCustomPayload packet = new SPacketCustomPayload("worldedit:cui", buffer);
        this.player.connection.sendPacket((Packet)packet);
    }

    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage((ITextComponent)new TextComponentString(part));
        }
    }

    public void printDebug(String msg) {
        this.sendColorized(msg, TextFormatting.GRAY);
    }

    public void print(String msg) {
        this.sendColorized(msg, TextFormatting.LIGHT_PURPLE);
    }

    public void printError(String msg) {
        this.sendColorized(msg, TextFormatting.RED);
    }

    private void sendColorized(String msg, TextFormatting formatting) {
        for (String part : msg.split("\n")) {
            TextComponentString component = new TextComponentString(part);
            component.getStyle().setColor(formatting);
            this.player.sendMessage((ITextComponent)component);
        }
    }

    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.connection.setPlayerLocation(pos.getX(), pos.getY(), pos.getZ(), yaw, pitch);
    }

    public String[] getGroups() {
        return new String[0];
    }

    public BlockBag getInventoryBlockBag() {
        return null;
    }

    public boolean hasPermission(String perm) {
        return ForgeWorldEdit.inst.getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    public void sendFakeBlock(Vector pos, BlockStateHolder block) {
        BlockPos loc = new BlockPos(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
        if (block != null && block instanceof BaseBlock && ((BaseBlock)block).hasNbtData()) {
            this.player.connection.sendPacket((Packet)new SPacketUpdateTileEntity(new BlockPos(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, NBTConverter.toNative(((BaseBlock)block).getNbtData())));
        }
    }

    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.getUniqueID(), this.player.getName());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        public boolean isPersistent() {
            return true;
        }
    }
}

