/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.TileEntityUtils;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;

public class ForgeWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final IBlockState JUNGLE_LOG = Blocks.LOG.getDefaultState().withProperty((IProperty)BlockOldLog.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.LEAVES.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.JUNGLE).withProperty((IProperty)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
    private static final IBlockState JUNGLE_SHRUB = Blocks.LEAVES.getDefaultState().withProperty((IProperty)BlockOldLeaf.VARIANT, (Comparable)BlockPlanks.EnumType.OAK).withProperty((IProperty)BlockLeaves.CHECK_DECAY, (Comparable)Boolean.valueOf(false));
    private final WeakReference<World> worldRef;

    ForgeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
    }

    public World getWorldChecked() throws WorldEditException {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public String getName() {
        return this.getWorld().getWorldInfo().getWorldName();
    }

    public boolean setBlock(Vector position, BlockStateHolder block, boolean notifyAndLight) throws WorldEditException {
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)block);
        World world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        Chunk chunk = world.getChunkFromChunkCoords(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState old = chunk.getBlockState(pos);
        IBlockState newState = Block.getBlockById((int)block.getBlockType().getLegacyId()).getDefaultState();
        IBlockState successState = chunk.setBlockState(pos, newState);
        boolean bl = successful = successState != null;
        if (successful && block instanceof BaseBlock && ((BaseBlock)block).hasNbtData()) {
            world.removeTileEntity(pos);
            NBTTagCompound nativeTag = NBTConverter.toNative(((BaseBlock)block).getNbtData());
            nativeTag.setString("id", ((BaseBlock)block).getNbtId());
            TileEntityUtils.setTileEntity(world, position, nativeTag);
        }
        if (notifyAndLight) {
            if (!successful) {
                newState = old;
            }
            world.checkLight(pos);
            world.markAndNotifyBlock(pos, chunk, old, newState, 3);
        }
        return successful;
    }

    public int getBlockLightLevel(Vector position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().getLight(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
    }

    public boolean clearContainerBlockContents(Vector position) {
        Preconditions.checkNotNull((Object)position);
        TileEntity tile = this.getWorld().getTileEntity(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()));
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            int size = inv.getSizeInventory();
            for (int i = 0; i < size; ++i) {
                inv.setInventorySlotContents(i, ItemStack.EMPTY);
            }
            return true;
        }
        return false;
    }

    public BaseBiome getBiome(Vector2D position) {
        Preconditions.checkNotNull((Object)position);
        return new BaseBiome(Biome.getIdForBiome((Biome)this.getWorld().getBiomeForCoordsBody(new BlockPos(position.getBlockX(), 0, position.getBlockZ()))));
    }

    public boolean setBiome(Vector2D position, BaseBiome biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        Chunk chunk = this.getWorld().getChunkFromBlockCoords(new BlockPos(position.getBlockX(), 0, position.getBlockZ()));
        if (chunk.isLoaded()) {
            chunk.getBiomeArray()[(position.getBlockZ() & 0xF) << 4 | position.getBlockX() & 0xF] = (byte)biome.getId();
            return true;
        }
        return false;
    }

    public boolean useItem(Vector position, BaseItem item, Direction face) {
        Item nativeItem = Item.getByNameOrId((String)item.getType().getId());
        ItemStack stack = null;
        stack = item.getNbtData() == null ? new ItemStack(nativeItem, 1, 0) : new ItemStack(nativeItem, 1, 0, NBTConverter.toNative(item.getNbtData()));
        World world = this.getWorld();
        EnumActionResult used = stack.onItemUse((EntityPlayer)new WorldEditFakePlayer((WorldServer)world), world, ForgeAdapter.toBlockPos(position), EnumHand.MAIN_HAND, ForgeAdapter.adapt(face), 0.0f, 0.0f, 0.0f);
        return used != EnumActionResult.FAIL;
    }

    public void dropItem(Vector position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        EntityItem entity = new EntityItem(this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeWorldEdit.toForgeItemStack(item));
        entity.setPickupDelay(10);
        this.getWorld().spawnEntity((Entity)entity);
    }

    public void simulateBlockMine(Vector position) {
        BlockPos pos = ForgeAdapter.toBlockPos(position);
        IBlockState state = this.getWorld().getBlockState(pos);
        state.getBlock().dropBlockAsItem(this.getWorld(), pos, state, 0);
        this.getWorld().setBlockToAir(pos);
    }

    public boolean regenerate(Region region, EditSession editSession) {
        IChunkProvider provider = this.getWorld().getChunkProvider();
        if (!(provider instanceof ChunkProviderServer)) {
            return false;
        }
        File saveFolder = Files.createTempDir();
        saveFolder.deleteOnExit();
        WorldServer originalWorld = (WorldServer)this.getWorld();
        MinecraftServer server = originalWorld.getMinecraftServer();
        AnvilSaveHandler saveHandler = new AnvilSaveHandler(saveFolder, originalWorld.getSaveHandler().getWorldDirectory().getName(), true, server.getDataFixer());
        World freshWorld = new WorldServer(server, (ISaveHandler)saveHandler, originalWorld.getWorldInfo(), originalWorld.provider.getDimension(), originalWorld.profiler).init();
        CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
        for (Object chunk : expandedPreGen.getChunks()) {
            freshWorld.getChunkFromChunkCoords(chunk.getBlockX(), chunk.getBlockZ());
        }
        ForgeWorld from = new ForgeWorld(freshWorld);
        try {
            for (BlockVector vec : region) {
                editSession.setBlock((Vector)vec, (BlockStateHolder)from.getFullBlock((Vector)vec));
            }
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        finally {
            saveFolder.delete();
            DimensionManager.setWorld((int)originalWorld.provider.getDimension(), null, (MinecraftServer)server);
            DimensionManager.setWorld((int)originalWorld.provider.getDimension(), (WorldServer)originalWorld, (MinecraftServer)server);
        }
        return true;
    }

    @Nullable
    private static WorldGenerator createWorldGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return new WorldGenTrees(true);
            }
            case BIG_TREE: {
                return new WorldGenBigTree(true);
            }
            case REDWOOD: {
                return new WorldGenTaiga2(true);
            }
            case TALL_REDWOOD: {
                return new WorldGenTaiga1();
            }
            case BIRCH: {
                return new WorldGenBirchTree(true, false);
            }
            case JUNGLE: {
                return new WorldGenMegaJungle(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
            }
            case SMALL_JUNGLE: {
                return new WorldGenTrees(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
            }
            case SHORT_JUNGLE: {
                return new WorldGenTrees(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case JUNGLE_BUSH: {
                return new WorldGenShrub(JUNGLE_LOG, JUNGLE_SHRUB);
            }
            case RED_MUSHROOM: {
                return new WorldGenBigMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
            }
            case BROWN_MUSHROOM: {
                return new WorldGenBigMushroom(Blocks.RED_MUSHROOM_BLOCK);
            }
            case SWAMP: {
                return new WorldGenSwamp();
            }
            case ACACIA: {
                return new WorldGenSavannaTree(true);
            }
            case DARK_OAK: {
                return new WorldGenCanopyTree(true);
            }
            case MEGA_REDWOOD: {
                return new WorldGenMegaPineTree(false, random.nextBoolean());
            }
            case TALL_BIRCH: {
                return new WorldGenBirchTree(true, true);
            }
        }
        return null;
    }

    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector position) throws MaxChangedBlocksException {
        WorldGenerator generator = ForgeWorld.createWorldGenerator(type);
        return generator != null && generator.generate(this.getWorld(), random, ForgeAdapter.toBlockPos(position));
    }

    public void checkLoadedChunk(Vector pt) {
        this.getWorld().getChunkFromBlockCoords(ForgeAdapter.toBlockPos(pt));
    }

    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
        this.fixLighting(chunks);
    }

    public void fixLighting(Iterable<BlockVector2D> chunks) {
        World world = this.getWorld();
        for (BlockVector2D chunk : chunks) {
            world.getChunkFromChunkCoords(chunk.getBlockX(), chunk.getBlockZ()).resetRelightChecks();
        }
    }

    public boolean playEffect(Vector position, int type, int data) {
        this.getWorld().playEvent(type, ForgeAdapter.toBlockPos(position), data);
        return true;
    }

    public WeatherType getWeather() {
        WorldInfo info = this.getWorld().getWorldInfo();
        if (info.isThundering()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.isRaining()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    public long getRemainingWeatherDuration() {
        WorldInfo info = this.getWorld().getWorldInfo();
        if (info.isThundering()) {
            return info.getThunderTime();
        }
        if (info.isRaining()) {
            return info.getRainTime();
        }
        return info.getCleanWeatherTime();
    }

    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    public void setWeather(WeatherType weatherType, long duration) {
        WorldInfo info = this.getWorld().getWorldInfo();
        if (WeatherTypes.THUNDER_STORM.equals((Object)weatherType)) {
            info.setCleanWeatherTime(0);
            info.setThundering(true);
            info.setThunderTime((int)duration);
        } else if (WeatherTypes.RAIN.equals((Object)weatherType)) {
            info.setCleanWeatherTime(0);
            info.setRaining(true);
            info.setRainTime((int)duration);
        } else if (WeatherTypes.CLEAR.equals((Object)weatherType)) {
            info.setRaining(false);
            info.setThundering(false);
            info.setCleanWeatherTime((int)duration);
        }
    }

    public BlockState getBlock(Vector position) {
        World world = this.getWorld();
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        IBlockState state = world.getBlockState(pos);
        return LegacyMapper.getInstance().getBlockFromLegacy(Block.getIdFromBlock((Block)state.getBlock()), state.getBlock().getMetaFromState(state));
    }

    public BaseBlock getFullBlock(Vector position) {
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        TileEntity tile = this.getWorld().getTileEntity(pos);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(TileEntityUtils.copyNbtData(tile)));
        }
        return this.getBlock(position).toBaseBlock();
    }

    public int hashCode() {
        return this.getWorld().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)((Object)o);
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof com.sk89q.worldedit.world.World) {
            return ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
        }
        return false;
    }

    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities(Region region) {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().loadedEntityList) {
            if (!region.contains(new Vector(entity.posX, entity.posY, entity.posZ))) continue;
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities() {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().loadedEntityList) {
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    @Nullable
    public com.sk89q.worldedit.entity.Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        Entity createdEntity = EntityList.createEntityByIDFromName((ResourceLocation)new ResourceLocation(entity.getType().getId()), (World)world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.removeTag(name);
                }
                createdEntity.readFromNBT(tag);
            }
            createdEntity.setLocationAndAngles(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.spawnEntity(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }

    private static class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

