/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.CommonProxy;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePermissionsProvider;
import com.sk89q.worldedit.forge.ForgePlatform;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.InternalPacketHandler;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.WECUIPacketHandler;
import com.sk89q.worldedit.forge.net.LeftClickAirEventMessage;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Logger;

@Mod(modid="worldedit", name="WorldEdit", version="7.0.0-SNAPSHOT", acceptableRemoteVersions="*")
public class ForgeWorldEdit {
    public static Logger logger;
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private ForgePermissionsProvider provider;
    @Mod.Instance(value="worldedit")
    public static ForgeWorldEdit inst;
    @SidedProxy(serverSide="com.sk89q.worldedit.forge.CommonProxy", clientSide="com.sk89q.worldedit.forge.ClientProxy")
    public static CommonProxy proxy;
    private ForgePlatform platform;
    private ForgeConfiguration config;
    private File workingDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        this.workingDir = new File(event.getModConfigurationDirectory() + File.separator + MOD_ID);
        this.workingDir.mkdir();
        this.config = new ForgeConfiguration(this);
        this.config.load();
        MinecraftForge.EVENT_BUS.register((Object)ThreadSafeCache.getInstance());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        WECUIPacketHandler.init();
        InternalPacketHandler.init();
        proxy.registerHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("WorldEdit for Forge (version " + this.getInternalVersion() + ") is loaded");
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        if (this.platform != null) {
            logger.warn("FMLServerStartingEvent occurred when FMLServerStoppingEvent hasn't");
            WorldEdit.getInstance().getPlatformManager().unregister((Platform)this.platform);
        }
        this.platform = new ForgePlatform(this);
        WorldEdit.getInstance().getPlatformManager().register((Platform)this.platform);
        this.provider = Loader.isModLoaded((String)"sponge") ? new ForgePermissionsProvider.SpongePermissionsProvider() : new ForgePermissionsProvider.VanillaPermissionsProvider(this.platform);
        for (Block block : Block.REGISTRY) {
            BlockTypes.register((BlockType)new BlockType(((ResourceLocation)Block.REGISTRY.getNameForObject((Object)block)).toString()));
        }
        for (Item item : Item.REGISTRY) {
            ItemTypes.register((ItemType)new ItemType(((ResourceLocation)Item.REGISTRY.getNameForObject((Object)item)).toString()));
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        worldEdit.getPlatformManager().unregister((Platform)this.platform);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent());
    }

    @SubscribeEvent
    public void onCommandEvent(net.minecraftforge.event.CommandEvent event) {
        if (event.getSender() instanceof EntityPlayerMP) {
            if (((EntityPlayerMP)event.getSender()).world.isRemote) {
                return;
            }
            Object[] split = new String[event.getParameters().length + 1];
            System.arraycopy(event.getParameters(), 0, split, 1, event.getParameters().length);
            split[0] = event.getCommand().getName();
            CommandEvent weEvent = new CommandEvent((Actor)this.wrap((EntityPlayerMP)event.getSender()), Joiner.on((String)" ").join(split));
            WorldEdit.getInstance().getEventBus().post((Object)weEvent);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isRightDeny;
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        if (event.getWorld().isRemote && event instanceof PlayerInteractEvent.LeftClickEmpty) {
            InternalPacketHandler.CHANNEL.sendToServer((IMessage)new LeftClickAirEventMessage());
            return;
        }
        boolean isLeftDeny = event instanceof PlayerInteractEvent.LeftClickBlock && ((PlayerInteractEvent.LeftClickBlock)event).getUseItem() == Event.Result.DENY;
        boolean bl = isRightDeny = event instanceof PlayerInteractEvent.RightClickBlock && ((PlayerInteractEvent.RightClickBlock)event).getUseItem() == Event.Result.DENY;
        if (isLeftDeny || isRightDeny || event.getEntity().world.isRemote) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        ForgePlayer player = this.wrap((EntityPlayerMP)event.getEntityPlayer());
        ForgeWorld world = this.getWorld(event.getEntityPlayer().world);
        if (event instanceof PlayerInteractEvent.LeftClickEmpty) {
            if (we.handleArmSwing((Player)player)) {
                // empty if block
            }
        } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            Location pos = new Location((Extent)world, (double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ());
            if (we.handleBlockLeftClick((Player)player, pos)) {
                event.setCanceled(true);
            }
            if (we.handleArmSwing((Player)player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
            Location pos = new Location((Extent)world, (double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ());
            if (we.handleBlockRightClick((Player)player, pos)) {
                event.setCanceled(true);
            }
            if (we.handleRightClick((Player)player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickItem && we.handleRightClick((Player)player)) {
            event.setCanceled(true);
        }
    }

    public static ItemStack toForgeItemStack(BaseItemStack item) {
        NBTTagCompound forgeCompound = null;
        if (item.getNbtData() != null) {
            forgeCompound = NBTConverter.toNative(item.getNbtData());
        }
        return new ItemStack(Item.getByNameOrId((String)item.getType().getId()), item.getAmount(), 0, forgeCompound);
    }

    ForgeConfiguration getConfig() {
        return this.config;
    }

    public ForgePlayer wrap(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return new ForgePlayer(player);
    }

    public LocalSession getSession(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrap(player));
    }

    public ForgeWorld getWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        return new ForgeWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    String getInternalVersion() {
        return ForgeWorldEdit.class.getAnnotation(Mod.class).version();
    }

    public void setPermissionsProvider(ForgePermissionsProvider provider) {
        this.provider = provider;
    }

    public ForgePermissionsProvider getPermissionsProvider() {
        return this.provider;
    }
}

