/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class WECUIPacketHandler {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static FMLEventChannel WECUI_CHANNEL;

    public static void init() {
        WECUI_CHANNEL = NetworkRegistry.INSTANCE.newEventDrivenChannel("worldedit:cui");
        WECUI_CHANNEL.register((Object)new WECUIPacketHandler());
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (event.getPacket().channel().equals("worldedit:cui")) {
            EntityPlayerMP player = WECUIPacketHandler.getPlayerFromEvent(event);
            LocalSession session = ForgeWorldEdit.inst.getSession(player);
            if (session.hasCUISupport()) {
                return;
            }
            String text = event.getPacket().payload().toString(UTF_8_CHARSET);
            session.handleCUIInitializationMessage(text);
            session.describeCUI((Actor)ForgeWorldEdit.inst.wrap(player));
        }
    }

    @SubscribeEvent
    public void callProcessPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            new SPacketCustomPayload(event.getPacket().channel(), new PacketBuffer(event.getPacket().payload())).processPacket((INetHandlerPlayClient)event.getHandler());
        }
        catch (ThreadQuickExitException threadQuickExitException) {
            // empty catch block
        }
    }

    private static EntityPlayerMP getPlayerFromEvent(FMLNetworkEvent.ServerCustomPacketEvent event) {
        return ((NetHandlerPlayServer)event.getHandler()).player;
    }
}

