/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text;

import com.sk89q.worldedit.util.formatting.text.Component0;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Component {
    public static Component empty() {
        return Component0.EMPTY;
    }

    public static Component newline() {
        return Component0.NEWLINE;
    }

    public static Component space() {
        return Component0.SPACE;
    }

    public static @NonNull Component of(boolean value) {
        return TextComponent.of(String.valueOf(value));
    }

    public static @NonNull Component of(char value) {
        if (value == '\n') {
            return Component.newline();
        }
        if (value == ' ') {
            return Component.space();
        }
        return TextComponent.of(String.valueOf(value));
    }

    public static @NonNull Component of(double value) {
        return TextComponent.of(String.valueOf(value));
    }

    public static @NonNull Component of(float value) {
        return TextComponent.of(String.valueOf(value));
    }

    public static @NonNull Component of(int value) {
        return TextComponent.of(String.valueOf(value));
    }

    public static @NonNull Component of(long value) {
        return TextComponent.of(String.valueOf(value));
    }

    public @NonNull List<Component> children();

    default public boolean contains(@NonNull Component that) {
        if (this == that) {
            return true;
        }
        for (Component child : this.children()) {
            if (!child.contains(that)) continue;
            return true;
        }
        if (this.hoverEvent() != null) {
            Component hover = this.hoverEvent().value();
            if (that == hover) {
                return true;
            }
            for (Component child : hover.children()) {
                if (!child.contains(that)) continue;
                return true;
            }
        }
        return false;
    }

    default public void detectCycle(@NonNull Component that) {
        if (that.contains(this)) {
            throw new IllegalStateException("Component cycle detected between " + this + " and " + that);
        }
    }

    public @NonNull Component append(@NonNull Component var1);

    public @NonNull Component copy();

    public @Nullable TextColor color();

    public @NonNull Component color(@Nullable TextColor var1);

    default public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NonNull TextDecoration.State decoration(@NonNull TextDecoration var1);

    default public @NonNull Component decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    public @NonNull Component decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

    default public @NonNull Set<TextDecoration> decorations() {
        return this.decorations(Collections.emptySet());
    }

    default public @NonNull Set<TextDecoration> decorations(@NonNull Set<TextDecoration> defaultValues) {
        EnumSet<TextDecoration> decorations = EnumSet.noneOf(TextDecoration.class);
        for (TextDecoration decoration : TextDecoration.values()) {
            TextDecoration.State value = this.decoration(decoration);
            if (value != TextDecoration.State.TRUE && (value != TextDecoration.State.NOT_SET || !defaultValues.contains(decoration))) continue;
            decorations.add(decoration);
        }
        return decorations;
    }

    public @Nullable ClickEvent clickEvent();

    public @NonNull Component clickEvent(@Nullable ClickEvent var1);

    public @Nullable HoverEvent hoverEvent();

    public @NonNull Component hoverEvent(@Nullable HoverEvent var1);

    public @Nullable String insertion();

    public @NonNull Component insertion(@Nullable String var1);

    public @NonNull Component mergeStyle(@NonNull Component var1);

    public @NonNull Component mergeColor(@NonNull Component var1);

    public @NonNull Component mergeDecorations(@NonNull Component var1);

    public @NonNull Component mergeEvents(@NonNull Component var1);

    public @NonNull Component resetStyle();

    public boolean hasStyling();
}

