/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text.adapter.bukkit;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.Adapter;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.NameMapSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class SpigotAdapter
implements Adapter {
    private static final boolean BOUND = SpigotAdapter.bind();

    SpigotAdapter() {
    }

    private static boolean bind() {
        try {
            Class<?> treeTypeAdapterClass;
            Field gsonField = ComponentSerializer.class.getDeclaredField("gson");
            gsonField.setAccessible(true);
            Gson gson = (Gson)gsonField.get(null);
            Field factoriesField = Gson.class.getDeclaredField("factories");
            factoriesField.setAccessible(true);
            List factories = (List)factoriesField.get(gson);
            ArrayList<TypeAdapterFactory> modifiedFactories = new ArrayList<TypeAdapterFactory>(factories);
            try {
                treeTypeAdapterClass = Class.forName("com.google.gson.internal.bind.TreeTypeAdapter");
            }
            catch (ClassNotFoundException e) {
                treeTypeAdapterClass = Class.forName("com.google.gson.TreeTypeAdapter");
            }
            Method newTypeHierarchyFactoryMethod = treeTypeAdapterClass.getMethod("newTypeHierarchyFactory", Class.class, Object.class);
            TypeAdapterFactory factory1 = (TypeAdapterFactory)newTypeHierarchyFactoryMethod.invoke(null, Component.class, GsonComponentSerializer.INSTANCE);
            modifiedFactories.add(0, factory1);
            Method newFactoryWithMatchRawTypeMethod = treeTypeAdapterClass.getMethod("newFactoryWithMatchRawType", TypeToken.class, Object.class);
            TypeAdapterFactory factory2 = (TypeAdapterFactory)newFactoryWithMatchRawTypeMethod.invoke(null, TypeToken.get(AdapterComponent.class), new Serializer());
            modifiedFactories.add(0, factory2);
            Method newFactoryMethod = treeTypeAdapterClass.getMethod("newFactory", TypeToken.class, Object.class);
            modifiedFactories.add(1, (TypeAdapterFactory)newFactoryMethod.invoke(null, TypeToken.get(ClickEvent.Action.class), new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)));
            modifiedFactories.add(1, (TypeAdapterFactory)newFactoryMethod.invoke(null, TypeToken.get(HoverEvent.Action.class), new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)));
            modifiedFactories.add(1, (TypeAdapterFactory)newFactoryMethod.invoke(null, TypeToken.get(TextColor.class), new NameMapSerializer<TextColor>("text color", TextColor.NAMES)));
            modifiedFactories.add(1, (TypeAdapterFactory)newFactoryMethod.invoke(null, TypeToken.get(TextDecoration.class), new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES)));
            factoriesField.set(gson, modifiedFactories);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void sendComponent(List<? extends CommandSender> viewers, Component component, boolean actionBar) {
        if (!BOUND) {
            return;
        }
        BaseComponent[] components = new BaseComponent[]{new AdapterComponent(component)};
        Iterator<? extends CommandSender> it = viewers.iterator();
        while (it.hasNext()) {
            CommandSender viewer = it.next();
            if (!(viewer instanceof Player)) continue;
            try {
                Player player = (Player)viewer;
                if (actionBar) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
                } else {
                    player.spigot().sendMessage(components);
                }
                it.remove();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static class Serializer
    implements JsonSerializer<AdapterComponent> {
        public JsonElement serialize(AdapterComponent src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.component);
        }
    }

    public static final class AdapterComponent
    extends BaseComponent {
        private final Component component;

        AdapterComponent(Component component) {
            this.component = component;
        }

        public BaseComponent duplicate() {
            return this;
        }
    }
}

