/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text.event;

import com.sk89q.worldedit.util.formatting.text.util.NameMap;
import java.util.Objects;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClickEvent {
    private final Action action;
    private final String value;

    public ClickEvent(@NonNull Action action, @NonNull String value) {
        this.action = action;
        this.value = value;
    }

    public @NonNull Action action() {
        return this.action;
    }

    public @NonNull String value() {
        return this.value;
    }

    public @NonNull ClickEvent copy() {
        return new ClickEvent(this.action, this.value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickEvent that = (ClickEvent)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("action=" + (Object)((Object)this.action)).add("value=" + this.value).toString();
    }

    public static enum Action {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true);

        public static final NameMap<Action> NAMES;
        private final String name;
        private final boolean readable;

        private Action(String name, boolean readable) {
            this.name = name;
            this.readable = readable;
        }

        public boolean readable() {
            return this.readable;
        }

        @Deprecated
        public boolean isReadable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.name;
        }

        static {
            NAMES = NameMap.create((Enum[])Action.values(), constant -> constant.name);
        }
    }
}

