/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.sk89q.worldedit.util.formatting.text.AbstractBuildableComponent;
import com.sk89q.worldedit.util.formatting.text.BuildableComponent;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.KeybindComponent;
import com.sk89q.worldedit.util.formatting.text.ScoreComponent;
import com.sk89q.worldedit.util.formatting.text.SelectorComponent;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import com.sk89q.worldedit.util.formatting.text.serializer.ComponentSerializer;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.NameMapSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    private static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, (Object)INSTANCE).registerTypeAdapter(ClickEvent.Action.class, new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)).registerTypeAdapter(HoverEvent.Action.class, new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter(TextColor.class, new NameMapSerializer<TextColor>("text color", TextColor.NAMES)).registerTypeAdapter(TextDecoration.class, new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES));
        return builder;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)GSON.fromJson(string, Component.class);
    }

    public BuildableComponent<?, ?> deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject hoverEvent;
        ClickEvent.Action action;
        JsonObject clickEvent;
        AbstractBuildableComponent.AbstractBuilder component;
        if (element.isJsonPrimitive()) {
            return TextComponent.of(element.getAsString());
        }
        if (!element.isJsonObject()) {
            if (element.isJsonArray()) {
                BuildableComponent.Builder parent = null;
                for (JsonElement childElement : element.getAsJsonArray()) {
                    Object child = this.deserialize(childElement, childElement.getClass(), context);
                    if (parent == null) {
                        parent = child.toBuilder();
                        continue;
                    }
                    parent.append((Component)child);
                }
                if (parent == null) {
                    throw new JsonParseException("Don't know how to turn " + element + " into a Component");
                }
                return parent.build();
            }
            throw new JsonParseException("Don't know how to turn " + element + " into a Component");
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has("text")) {
            component = TextComponent.builder(object.get("text").getAsString());
        } else if (object.has("translate")) {
            String key = object.get("translate").getAsString();
            if (!object.has("with")) {
                component = TranslatableComponent.builder(key);
            } else {
                JsonArray with = object.getAsJsonArray("with");
                ArrayList<Component> args = new ArrayList<Component>(with.size());
                int size = with.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement argElement = with.get(i);
                    args.add((Component)this.deserialize(argElement, argElement.getClass(), context));
                }
                component = TranslatableComponent.builder(key).args(args);
            }
        } else if (object.has("score")) {
            JsonObject score = object.getAsJsonObject("score");
            if (!score.has("name") && !score.has("objective")) {
                throw new JsonParseException("A score component requires a name and objective");
            }
            component = score.has("value") ? ScoreComponent.builder().name(score.get("name").getAsString()).objective(score.get("objective").getAsString()).value(score.get("value").getAsString()) : ScoreComponent.builder().name(score.get("name").getAsString()).objective(score.get("objective").getAsString());
        } else if (object.has("selector")) {
            component = SelectorComponent.builder().pattern(object.get("selector").getAsString());
        } else if (object.has("keybind")) {
            component = KeybindComponent.builder().keybind(object.get("keybind").getAsString());
        } else {
            throw new JsonParseException("Don't know how to turn " + element + " into a Component");
        }
        if (object.has("extra")) {
            JsonArray extra = object.getAsJsonArray("extra");
            int size = extra.size();
            for (int i = 0; i < size; ++i) {
                JsonElement extraElement = extra.get(i);
                component.append((Component)this.deserialize(extraElement, extraElement.getClass(), context));
            }
        }
        if (object.has("bold")) {
            component.decoration(TextDecoration.BOLD, object.get("bold").getAsBoolean());
        }
        if (object.has("italic")) {
            component.decoration(TextDecoration.ITALIC, object.get("italic").getAsBoolean());
        }
        if (object.has("underlined")) {
            component.decoration(TextDecoration.UNDERLINED, object.get("underlined").getAsBoolean());
        }
        if (object.has("strikethrough")) {
            component.decoration(TextDecoration.STRIKETHROUGH, object.get("strikethrough").getAsBoolean());
        }
        if (object.has("obfuscated")) {
            component.decoration(TextDecoration.OBFUSCATED, object.get("obfuscated").getAsBoolean());
        }
        if (object.has("color")) {
            component.color((TextColor)context.deserialize(object.get("color"), TextColor.class));
        }
        if (object.has("insertion")) {
            component.insertion(object.get("insertion").getAsString());
        }
        if (object.has("clickEvent") && (clickEvent = object.getAsJsonObject("clickEvent")) != null) {
            String value;
            JsonPrimitive rawAction = clickEvent.getAsJsonPrimitive("action");
            action = rawAction == null ? null : (ClickEvent.Action)((Object)context.deserialize((JsonElement)rawAction, ClickEvent.Action.class));
            JsonPrimitive rawValue = clickEvent.getAsJsonPrimitive("value");
            String string = value = rawValue == null ? null : rawValue.getAsString();
            if (action != null && value != null && action.readable()) {
                component.clickEvent(new ClickEvent(action, value));
            }
        }
        if (object.has("hoverEvent") && (hoverEvent = object.getAsJsonObject("hoverEvent")) != null) {
            JsonPrimitive rawAction = hoverEvent.getAsJsonPrimitive("action");
            Enum enum_ = action = rawAction == null ? null : (HoverEvent.Action)((Object)context.deserialize((JsonElement)rawAction, HoverEvent.Action.class));
            if (action != null && ((HoverEvent.Action)((Object)action)).readable()) {
                Object value;
                JsonElement rawValue = hoverEvent.get("value");
                Object object2 = value = rawValue == null ? null : this.deserialize(rawValue, rawValue.getClass(), context);
                if (value != null) {
                    component.hoverEvent(new HoverEvent((HoverEvent.Action)((Object)action), (Component)value));
                }
            }
        }
        return component.build();
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson((Object)component);
    }

    public JsonElement serialize(Component component, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (component instanceof TextComponent) {
            object.addProperty("text", ((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)component;
            object.addProperty("translate", tc.key());
            if (!tc.args().isEmpty()) {
                JsonArray with = new JsonArray();
                for (Component arg : tc.args()) {
                    with.add(this.serialize(arg, arg.getClass(), context));
                }
                object.add("with", (JsonElement)with);
            }
        } else if (component instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)component;
            JsonObject score = new JsonObject();
            score.addProperty("name", sc.name());
            score.addProperty("objective", sc.objective());
            if (sc.value() != null) {
                score.addProperty("value", sc.value());
            }
            object.add("score", (JsonElement)score);
        } else if (component instanceof SelectorComponent) {
            object.addProperty("selector", ((SelectorComponent)component).pattern());
        } else if (component instanceof KeybindComponent) {
            object.addProperty("keybind", ((KeybindComponent)component).keybind());
        } else {
            throw new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
        }
        if (!component.children().isEmpty()) {
            TextDecoration[] extra = new JsonArray();
            for (Component child : component.children()) {
                extra.add(this.serialize(child, child.getClass(), context));
            }
            object.add("extra", (JsonElement)extra);
        }
        if (component.hasStyling()) {
            HoverEvent hoverEvent;
            ClickEvent clickEvent;
            for (TextDecoration decoration : TextDecoration.values()) {
                TextDecoration.State flag = component.decoration(decoration);
                if (flag == TextDecoration.State.NOT_SET) continue;
                object.addProperty(decoration.toString(), Boolean.valueOf(flag == TextDecoration.State.TRUE));
            }
            if (component.color() != null) {
                object.add("color", context.serialize((Object)component.color()));
            }
            if (component.insertion() != null) {
                object.add("insertion", context.serialize((Object)component.insertion()));
            }
            if ((clickEvent = component.clickEvent()) != null) {
                JsonObject clickEventO = new JsonObject();
                clickEventO.add("action", context.serialize((Object)clickEvent.action()));
                clickEventO.addProperty("value", clickEvent.value());
                object.add("clickEvent", (JsonElement)clickEventO);
            }
            if ((hoverEvent = component.hoverEvent()) != null) {
                JsonObject hoverEventO = new JsonObject();
                hoverEventO.add("action", context.serialize((Object)hoverEvent.action()));
                hoverEventO.add("value", this.serialize(hoverEvent.value(), type, context));
                object.add("hoverEvent", (JsonElement)hoverEventO);
            }
        }
        return object;
    }
}

