/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.QueryCache;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.FailedLoadRegionSet;
import com.sk89q.worldguard.protection.GlobalRegionManager;
import com.sk89q.worldguard.protection.PermissiveRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Collection;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RegionQuery {
    private final WorldGuardPlugin plugin;
    private final ConfigurationManager config;
    private final GlobalRegionManager globalManager;
    private final QueryCache cache;

    RegionQuery(WorldGuardPlugin plugin, QueryCache cache) {
        Preconditions.checkNotNull((Object)((Object)plugin));
        Preconditions.checkNotNull((Object)cache);
        this.plugin = plugin;
        this.config = plugin.getGlobalStateManager();
        this.cache = cache;
        this.globalManager = plugin.getGlobalRegionManager();
    }

    public ApplicableRegionSet getApplicableRegions(Location location) {
        Preconditions.checkNotNull((Object)location);
        World world = location.getWorld();
        WorldConfiguration worldConfig = this.config.get(world);
        if (!worldConfig.useRegions) {
            return PermissiveRegionSet.getInstance();
        }
        RegionManager manager = this.globalManager.get(location.getWorld());
        if (manager != null) {
            return this.cache.queryContains(manager, location);
        }
        return FailedLoadRegionSet.getInstance();
    }

    public boolean testBuild(Location location, Player player, StateFlag ... flag) {
        if (flag.length == 0) {
            return this.testState(location, player, DefaultFlag.BUILD);
        }
        return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, player, DefaultFlag.BUILD)), this.queryState(location, player, flag)));
    }

    public boolean testBuild(Location location, RegionAssociable associable, StateFlag ... flag) {
        if (flag.length == 0) {
            return this.testState(location, associable, DefaultFlag.BUILD);
        }
        return StateFlag.test(StateFlag.combine(StateFlag.denyToNone(this.queryState(location, associable, DefaultFlag.BUILD)), this.queryState(location, associable, flag)));
    }

    public boolean testState(Location location, @Nullable Player player, StateFlag ... flag) {
        return StateFlag.test(this.queryState(location, player, flag));
    }

    public boolean testState(Location location, @Nullable RegionAssociable associable, StateFlag ... flag) {
        return StateFlag.test(this.queryState(location, associable, flag));
    }

    @Nullable
    public StateFlag.State queryState(Location location, @Nullable Player player, StateFlag ... flags) {
        LocalPlayer localPlayer = player != null ? this.plugin.wrapPlayer(player) : null;
        return this.getApplicableRegions(location).queryState(localPlayer, flags);
    }

    @Nullable
    public StateFlag.State queryState(Location location, @Nullable RegionAssociable associable, StateFlag ... flags) {
        return this.getApplicableRegions(location).queryState(associable, flags);
    }

    @Nullable
    public <V> V queryValue(Location location, @Nullable Player player, Flag<V> flag) {
        LocalPlayer localPlayer = player != null ? this.plugin.wrapPlayer(player) : null;
        return this.getApplicableRegions(location).queryValue(localPlayer, flag);
    }

    @Nullable
    public <V> V queryValue(Location location, @Nullable RegionAssociable associable, Flag<V> flag) {
        return this.getApplicableRegions(location).queryValue(associable, flag);
    }

    public <V> Collection<V> queryAllValues(Location location, @Nullable Player player, Flag<V> flag) {
        LocalPlayer localPlayer = player != null ? this.plugin.wrapPlayer(player) : null;
        return this.getApplicableRegions(location).queryAllValues(localPlayer, flag);
    }

    public <V> Collection<V> queryAllValues(Location location, @Nullable RegionAssociable associable, Flag<V> flag) {
        return this.getApplicableRegions(location).queryAllValues(associable, flag);
    }
}

