/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.listener;

import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.listener.AbstractListener;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;

public class InvincibilityListener
extends AbstractListener {
    public InvincibilityListener(WorldGuardPlugin plugin) {
        super(plugin);
    }

    private boolean isInvincible(Player player) {
        return this.getPlugin().getSessionManager().get(player).isInvincible(player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        Entity victim = event.getEntity();
        WorldConfiguration worldConfig = this.getPlugin().getGlobalStateManager().get(victim.getWorld());
        if (victim instanceof Player && this.isInvincible(player = (Player)victim)) {
            player.setFireTicks(0);
            event.setCancelled(true);
            if (event instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent byEntityEvent = (EntityDamageByEntityEvent)event;
                Entity attacker = byEntityEvent.getDamager();
                if (!(!worldConfig.regionInvinciblityRemovesMobs || !(attacker instanceof LivingEntity) || attacker instanceof Player || attacker instanceof Tameable && ((Tameable)attacker).isTamed())) {
                    attacker.remove();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.isInvincible(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event.getFoodLevel() < player.getFoodLevel() && this.isInvincible(player)) {
                event.setCancelled(true);
            }
        }
    }
}

