/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.util.report;

import com.sk89q.worldguard.blacklist.Blacklist;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.util.report.DataReport;
import com.sk89q.worldguard.util.report.RegionReport;
import com.sk89q.worldguard.util.report.ShallowObjectReport;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class ConfigReport
extends DataReport {
    public ConfigReport(WorldGuardPlugin plugin) {
        super("WorldGuard Configuration");
        List worlds = Bukkit.getServer().getWorlds();
        this.append("Configuration", new ShallowObjectReport("Configuration", plugin.getGlobalStateManager()));
        for (World world : worlds) {
            WorldConfiguration config = plugin.getGlobalStateManager().get(world);
            DataReport report = new DataReport("World: " + world.getName());
            report.append("UUID", world.getUID());
            report.append("Configuration", new ShallowObjectReport("Configuration", config));
            Blacklist blacklist = config.getBlacklist();
            if (blacklist != null) {
                DataReport section = new DataReport("Blacklist");
                section.append("Rule Count", blacklist.getItemCount());
                section.append("Whitelist Mode?", blacklist.isWhitelist());
                report.append(section.getTitle(), section);
            } else {
                report.append("Blacklist", "<Disabled>");
            }
            RegionManager regions = plugin.getRegionContainer().get(world);
            if (regions != null) {
                DataReport section = new DataReport("Regions");
                section.append("Region Count", regions.size());
                ProtectedRegion global = regions.getRegion("__global__");
                if (global != null) {
                    section.append("__global__", new RegionReport(global));
                } else {
                    section.append("__global__", "<Undefined>");
                }
                report.append(section.getTitle(), section);
            } else {
                report.append("Regions", "<Disabled>");
            }
            this.append(report.getTitle(), report);
        }
    }
}

