/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.AbstractRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;

public class FailedLoadRegionSet
extends AbstractRegionSet {
    private static final FailedLoadRegionSet INSTANCE = new FailedLoadRegionSet();
    private final String denyMessage = ChatColor.RED + "Region data for WorldGuard failed to load for this world, so " + "everything has been protected as a precaution. Please inform a server administrator.";
    private final Collection<String> denyMessageCollection = ImmutableList.of((Object)this.denyMessage);

    private FailedLoadRegionSet() {
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @Nullable
    public <V> V queryValue(@Nullable RegionAssociable subject, Flag<V> flag) {
        if (flag == DefaultFlag.BUILD) {
            return (V)((Object)StateFlag.State.DENY);
        }
        if (flag == DefaultFlag.DENY_MESSAGE) {
            return (V)this.denyMessage;
        }
        return flag.getDefault();
    }

    @Override
    public <V> Collection<V> queryAllValues(@Nullable RegionAssociable subject, Flag<V> flag) {
        if (flag == DefaultFlag.BUILD) {
            return ImmutableList.of((Object)((Object)StateFlag.State.DENY));
        }
        if (flag == DefaultFlag.DENY_MESSAGE) {
            return this.denyMessageCollection;
        }
        V fallback = flag.getDefault();
        return fallback != null ? ImmutableList.of(fallback) : ImmutableList.of();
    }

    @Override
    public boolean isOwnerOfAll(LocalPlayer player) {
        return false;
    }

    @Override
    public boolean isMemberOfAll(LocalPlayer player) {
        return false;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Set<ProtectedRegion> getRegions() {
        return Collections.emptySet();
    }

    @Override
    public Iterator<ProtectedRegion> iterator() {
        return Iterators.emptyIterator();
    }

    public static FailedLoadRegionSet getInstance() {
        return INSTANCE;
    }
}

