/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.managers.index;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.protection.managers.index.HashMapIndex;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegionMBRConverter;
import java.util.Collections;
import java.util.HashSet;
import org.khelekore.prtree.MBRConverter;
import org.khelekore.prtree.PRTree;
import org.khelekore.prtree.SimpleMBR;

public class PriorityRTreeIndex
extends HashMapIndex {
    private static final int BRANCH_FACTOR = 30;
    private static final MBRConverter<ProtectedRegion> CONVERTER = new ProtectedRegionMBRConverter();
    private PRTree<ProtectedRegion> tree = new PRTree<ProtectedRegion>(CONVERTER, 30);

    public PriorityRTreeIndex() {
        this.tree.load(Collections.emptyList());
    }

    @Override
    protected void rebuildIndex() {
        PRTree<ProtectedRegion> newTree = new PRTree<ProtectedRegion>(CONVERTER, 30);
        newTree.load(this.values());
        this.tree = newTree;
    }

    @Override
    public void applyContaining(Vector position, Predicate<ProtectedRegion> consumer) {
        position = position.floor();
        HashSet<ProtectedRegion> seen = new HashSet<ProtectedRegion>();
        SimpleMBR pointMBR = new SimpleMBR(position.getX(), position.getX(), position.getY(), position.getY(), position.getZ(), position.getZ());
        for (ProtectedRegion region : this.tree.find(pointMBR)) {
            if (!region.contains(position) || seen.contains(region)) continue;
            seen.add(region);
            if (consumer.apply((Object)region)) continue;
            break;
        }
    }

    @Override
    public void applyIntersecting(ProtectedRegion region, Predicate<ProtectedRegion> consumer) {
        Vector min = region.getMinimumPoint().floor();
        Vector max = region.getMaximumPoint().ceil();
        HashSet<ProtectedRegion> candidates = new HashSet<ProtectedRegion>();
        SimpleMBR pointMBR = new SimpleMBR(min.getX(), max.getX(), min.getY(), max.getY(), min.getZ(), max.getZ());
        for (ProtectedRegion found : this.tree.find(pointMBR)) {
            candidates.add(found);
        }
        for (ProtectedRegion found : region.getIntersectingRegions(candidates)) {
            if (!consumer.apply((Object)found)) break;
        }
    }

    public static final class Factory
    implements Supplier<PriorityRTreeIndex> {
        public PriorityRTreeIndex get() {
            return new PriorityRTreeIndex();
        }
    }
}

