/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.guava.cache.CacheBuilder;
import com.sk89q.worldguard.internal.guava.cache.CacheLoader;
import com.sk89q.worldguard.internal.guava.cache.LoadingCache;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.WorldPlayerTuple;
import com.sk89q.worldguard.session.handler.EntryFlag;
import com.sk89q.worldguard.session.handler.ExitFlag;
import com.sk89q.worldguard.session.handler.FarewellFlag;
import com.sk89q.worldguard.session.handler.FeedFlag;
import com.sk89q.worldguard.session.handler.GameModeFlag;
import com.sk89q.worldguard.session.handler.GodMode;
import com.sk89q.worldguard.session.handler.GreetingFlag;
import com.sk89q.worldguard.session.handler.HealFlag;
import com.sk89q.worldguard.session.handler.InvincibilityFlag;
import com.sk89q.worldguard.session.handler.NotifyEntryFlag;
import com.sk89q.worldguard.session.handler.NotifyExitFlag;
import com.sk89q.worldguard.session.handler.TimeLockFlag;
import com.sk89q.worldguard.session.handler.WaterBreathing;
import com.sk89q.worldguard.session.handler.WeatherLockFlag;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class SessionManager
implements Runnable,
Listener {
    public static final int RUN_DELAY = 20;
    public static final long SESSION_LIFETIME = 10L;
    private final WorldGuardPlugin plugin;
    private final LoadingCache<WorldPlayerTuple, Boolean> bypassCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L, TimeUnit.SECONDS).build(new CacheLoader<WorldPlayerTuple, Boolean>(){

        @Override
        public Boolean load(WorldPlayerTuple tuple) throws Exception {
            return SessionManager.this.plugin.getGlobalRegionManager().hasBypass(tuple.player, tuple.world);
        }
    });
    private final LoadingCache<CacheKey, Session> sessions = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(new CacheLoader<CacheKey, Session>(){

        @Override
        public Session load(CacheKey key) throws Exception {
            return SessionManager.this.createSession((Player)key.playerRef.get());
        }
    });

    public SessionManager(WorldGuardPlugin plugin) {
        Preconditions.checkNotNull((Object)((Object)plugin), (Object)"plugin");
        this.plugin = plugin;
    }

    public WorldGuardPlugin getPlugin() {
        return this.plugin;
    }

    public boolean hasBypass(Player player, World world) {
        return this.bypassCache.getUnchecked(new WorldPlayerTuple(world, player));
    }

    public void resetAllStates() {
        Collection<? extends Player> players = BukkitUtil.getOnlinePlayers();
        for (Player player : players) {
            Session session = (Session)this.sessions.getIfPresent(new CacheKey(player));
            if (session == null) continue;
            session.resetState(player);
        }
    }

    public void resetState(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        Session session = (Session)this.sessions.getIfPresent(new CacheKey(player));
        if (session != null) {
            session.resetState(player);
        }
    }

    private Session createSession(Player player) {
        Session session = new Session(this);
        session.register(new HealFlag(session));
        session.register(new FeedFlag(session));
        session.register(new NotifyEntryFlag(session));
        session.register(new NotifyExitFlag(session));
        session.register(new EntryFlag(session));
        session.register(new ExitFlag(session));
        session.register(new GreetingFlag(session));
        session.register(new FarewellFlag(session));
        session.register(new GameModeFlag(session));
        session.register(new InvincibilityFlag(session));
        session.register(new TimeLockFlag(session));
        session.register(new WeatherLockFlag(session));
        session.register(new GodMode(session));
        session.register(new WaterBreathing(session));
        session.initialize(player);
        return session;
    }

    @Nullable
    public Session getIfPresent(Player player) {
        return (Session)this.sessions.getIfPresent(player);
    }

    public Session get(Player player) {
        return this.sessions.getUnchecked(new CacheKey(player));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.get(event.getPlayer());
    }

    @Override
    public void run() {
        for (Player player : BukkitUtil.getOnlinePlayers()) {
            this.get(player).tick(player);
        }
    }

    private static final class CacheKey {
        private final WeakReference<Player> playerRef;
        private final UUID uuid;

        private CacheKey(Player player) {
            this.playerRef = new WeakReference<Player>(player);
            this.uuid = player.getUniqueId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.uuid.equals(cacheKey.uuid);
        }

        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

