/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.session.handler;

import com.google.common.base.Preconditions;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class Handler {
    private final Session session;

    protected Handler(Session session) {
        Preconditions.checkNotNull((Object)session, (Object)"session");
        this.session = session;
    }

    public WorldGuardPlugin getPlugin() {
        return this.getSession().getManager().getPlugin();
    }

    public Session getSession() {
        return this.session;
    }

    public void initialize(Player player, Location current, ApplicableRegionSet set) {
    }

    public boolean testMoveTo(Player player, Location from, Location to, ApplicableRegionSet toSet, MoveType moveType) {
        return true;
    }

    public boolean onCrossBoundary(Player player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        return true;
    }

    public void tick(Player player, ApplicableRegionSet set) {
    }

    @Nullable
    public StateFlag.State getInvincibility(Player player) {
        return null;
    }
}

