/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util.profile.resolver;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.sk89q.worldguard.util.profile.Profile;
import com.sk89q.worldguard.util.profile.resolver.SingleRequestService;
import io.papermc.lib.PaperLib;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;

public final class PaperProfileService
extends SingleRequestService {
    private static final PaperProfileService INSTANCE = new PaperProfileService();

    private PaperProfileService() {
        if (!PaperLib.isPaper()) {
            throw new IllegalStateException("Attempt to access PaperProfileService on non-Paper server.");
        }
    }

    public int getIdealRequestLimit() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    public Profile findByName(String name) {
        PlayerProfile profile = Bukkit.createProfile((String)name);
        if (profile.completeFromCache()) {
            return new Profile(profile.getId(), profile.getName());
        }
        return null;
    }

    public static PaperProfileService getInstance() {
        return INSTANCE;
    }
}

