/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.session;

import co.aikar.timings.lib.MCTiming;
import co.aikar.timings.lib.TimingManager;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

class TimedHandlerFactory
extends Handler.Factory<Handler> {
    private static final TimingManager TIMINGS = TimingManager.of((Plugin)WorldGuardPlugin.inst());
    private static final MCTiming UNKNOWN_SOURCE = TIMINGS.of("Third-Party Session Handlers");
    private static final Map<CodeSource, TimingManager> PLUGIN_SOURCES = new HashMap<CodeSource, TimingManager>();
    private final Handler.Factory<?> factory;
    private final MCTiming timing;

    TimedHandlerFactory(Handler.Factory<?> factory) {
        this.factory = factory;
        this.timing = this.makeTiming();
    }

    private MCTiming makeTiming() {
        CodeSource codeSource = this.factory.getClass().getProtectionDomain().getCodeSource();
        TimingManager owner = PLUGIN_SOURCES.computeIfAbsent(codeSource, source -> {
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                CodeSource pluginSource = plugin.getClass().getProtectionDomain().getCodeSource();
                if (!Objects.equals(pluginSource, source)) continue;
                return TimingManager.of((Plugin)plugin);
            }
            return null;
        });
        String handlerName = this.factory.getClass().getEnclosingClass().getSimpleName();
        return owner == null ? TIMINGS.of(handlerName, UNKNOWN_SOURCE) : owner.of(handlerName, owner.of("Session Handlers"));
    }

    public Handler create(Session session) {
        return new TimedHandler(this.factory.create(session), session, this.timing);
    }

    static class TimedHandler
    extends Handler {
        private final Handler handler;
        private final MCTiming timing;

        TimedHandler(Handler innerHandler, Session session, MCTiming timing) {
            super(session);
            this.handler = innerHandler;
            this.timing = timing;
        }

        public void initialize(LocalPlayer player, Location current, ApplicableRegionSet set) {
            try (MCTiming ignored = this.timing.startTiming();){
                super.initialize(player, current, set);
            }
        }

        public boolean testMoveTo(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, MoveType moveType) {
            try (MCTiming ignored = this.timing.startTiming();){
                boolean bl = super.testMoveTo(player, from, to, toSet, moveType);
                return bl;
            }
        }

        public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
            try (MCTiming ignored = this.timing.startTiming();){
                boolean bl = super.onCrossBoundary(player, from, to, toSet, entered, exited, moveType);
                return bl;
            }
        }

        public void tick(LocalPlayer player, ApplicableRegionSet set) {
            try (MCTiming ignored = this.timing.startTiming();){
                super.tick(player, set);
            }
        }

        public Handler getWrappedHandler() {
            return this.handler;
        }
    }
}

