/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util;

import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.util.command.parametric.ExceptionConverterHelper;
import com.sk89q.worldedit.util.command.parametric.ExceptionMatch;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.util.UnresolvedNamesException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorldGuardExceptionConverter
extends ExceptionConverterHelper {
    private static final Pattern numberFormat = Pattern.compile("^For input string: \"(.*)\"$");
    private final WorldGuard worldGuard;

    public WorldGuardExceptionConverter(WorldGuard worldGuard) {
        Preconditions.checkNotNull((Object)worldGuard);
        this.worldGuard = worldGuard;
    }

    @ExceptionMatch
    public void convert(NumberFormatException e) throws CommandException {
        Matcher matcher = numberFormat.matcher(e.getMessage());
        if (matcher.matches()) {
            throw new CommandException("Number expected; string \"" + matcher.group(1) + "\" given.");
        }
        throw new CommandException("Number expected; string given.");
    }

    @ExceptionMatch
    public void convert(StorageException e) throws CommandException {
        WorldGuard.logger.log(Level.WARNING, "Error loading/saving regions", e);
        throw new CommandException("Region data could not be loaded/saved: " + e.getMessage());
    }

    @ExceptionMatch
    public void convert(RejectedExecutionException e) throws CommandException {
        throw new CommandException("There are currently too many tasks queued to add yours. Use /wg running to list queued and running tasks.", (Throwable)e);
    }

    @ExceptionMatch
    public void convert(CancellationException e) throws CommandException {
        throw new CommandException("WorldGuard: Task was cancelled.", (Throwable)e);
    }

    @ExceptionMatch
    public void convert(InterruptedException e) throws CommandException {
        throw new CommandException("WorldGuard: Task was interrupted.", (Throwable)e);
    }

    @ExceptionMatch
    public void convert(WorldEditException e) throws CommandException {
        throw new CommandException(e.getMessage(), (Throwable)e);
    }

    @ExceptionMatch
    public void convert(UnresolvedNamesException e) throws CommandException {
        throw new CommandException(e.getMessage(), (Throwable)e);
    }
}

