/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util.profile.resolver;

import com.sk89q.worldguard.util.profile.Profile;
import com.sk89q.worldguard.util.profile.resolver.SingleRequestService;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class HashMapService
extends SingleRequestService {
    private final ConcurrentHashMap<String, UUID> map = new ConcurrentHashMap();

    public HashMapService() {
    }

    public HashMapService(Map<String, UUID> map) {
        for (Map.Entry<String, UUID> entry : map.entrySet()) {
            this.map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    public void put(Profile profile) {
        this.map.put(profile.getName().toLowerCase(), profile.getUniqueId());
    }

    public void putAll(Collection<Profile> profiles) {
        for (Profile profile : profiles) {
            this.put(profile);
        }
    }

    @Override
    public int getIdealRequestLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public Profile findByName(String name) throws IOException, InterruptedException {
        UUID uuid = this.map.get(name.toLowerCase());
        if (uuid != null) {
            return new Profile(uuid, name);
        }
        return null;
    }
}

