/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ServerConnectedEvent {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable RegisteredServer previousServer;

    public ServerConnectedEvent(Player player, RegisteredServer server, @Nullable RegisteredServer previousServer) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.previousServer = previousServer;
    }

    @Deprecated
    public ServerConnectedEvent(Player player, RegisteredServer server) {
        this(player, server, null);
    }

    public Player getPlayer() {
        return this.player;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public Optional<RegisteredServer> getPreviousServer() {
        return Optional.ofNullable(this.previousServer);
    }

    public String toString() {
        return "ServerConnectedEvent{player=" + this.player + ", server=" + this.server + ", previousServer=" + this.previousServer + '}';
    }
}

