/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util.title;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.velocitypowered.api.util.title.Title;
import java.util.Objects;
import java.util.Optional;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public final class TextTitle
implements Title {
    private final @Nullable Component title;
    private final @Nullable Component subtitle;
    private final int stay;
    private final int fadeIn;
    private final int fadeOut;
    private final boolean resetBeforeSend;

    private TextTitle(Builder builder) {
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.stay = builder.stay;
        this.fadeIn = builder.fadeIn;
        this.fadeOut = builder.fadeOut;
        this.resetBeforeSend = builder.resetBeforeSend;
    }

    public Optional<Component> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Optional<Component> getSubtitle() {
        return Optional.ofNullable(this.subtitle);
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public boolean isResetBeforeSend() {
        return this.resetBeforeSend;
    }

    public boolean areTimesSet() {
        return this.stay != 0 || this.fadeIn != 0 || this.fadeOut != 0;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextTitle textTitle = (TextTitle)o;
        return this.stay == textTitle.stay && this.fadeIn == textTitle.fadeIn && this.fadeOut == textTitle.fadeOut && this.resetBeforeSend == textTitle.resetBeforeSend && Objects.equals(this.title, textTitle.title) && Objects.equals(this.subtitle, textTitle.subtitle);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.title).add("subtitle", (Object)this.subtitle).add("stay", this.stay).add("fadeIn", this.fadeIn).add("fadeOut", this.fadeOut).add("resetBeforeSend", this.resetBeforeSend).toString();
    }

    public int hashCode() {
        return Objects.hash(this.title, this.subtitle, this.stay, this.fadeIn, this.fadeOut, this.resetBeforeSend);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable Component title;
        private @Nullable Component subtitle;
        private int stay;
        private int fadeIn;
        private int fadeOut;
        private boolean resetBeforeSend = true;

        private Builder() {
        }

        private Builder(TextTitle copy) {
            this.title = copy.title;
            this.subtitle = copy.subtitle;
            this.stay = copy.stay;
            this.fadeIn = copy.fadeIn;
            this.fadeOut = copy.fadeOut;
            this.resetBeforeSend = copy.resetBeforeSend;
        }

        public Builder title(Component title) {
            this.title = (Component)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder clearTitle() {
            this.title = null;
            return this;
        }

        public Builder subtitle(Component subtitle) {
            this.subtitle = (Component)Preconditions.checkNotNull((Object)subtitle, (Object)"subtitle");
            return this;
        }

        public Builder clearSubtitle() {
            this.subtitle = null;
            return this;
        }

        private int checkTicks(int ticks) {
            Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (String)"ticks value %s is negative", (int)ticks);
            return ticks;
        }

        public Builder stay(int ticks) {
            this.stay = this.checkTicks(ticks);
            return this;
        }

        public Builder fadeIn(int ticks) {
            this.fadeIn = this.checkTicks(ticks);
            return this;
        }

        public Builder fadeOut(int ticks) {
            this.fadeOut = this.checkTicks(ticks);
            return this;
        }

        public Builder resetBeforeSend(boolean b) {
            this.resetBeforeSend = b;
            return this;
        }

        public Optional<Component> getTitle() {
            return Optional.ofNullable(this.title);
        }

        public Optional<Component> getSubtitle() {
            return Optional.ofNullable(this.subtitle);
        }

        public int getStay() {
            return this.stay;
        }

        public int getFadeIn() {
            return this.fadeIn;
        }

        public int getFadeOut() {
            return this.fadeOut;
        }

        public boolean isResetBeforeSend() {
            return this.resetBeforeSend;
        }

        public TextTitle build() {
            return new TextTitle(this);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("title", (Object)this.title).add("subtitle", (Object)this.subtitle).add("stay", this.stay).add("fadeIn", this.fadeIn).add("fadeOut", this.fadeOut).add("resetBeforeSend", this.resetBeforeSend).toString();
        }
    }
}

