/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.connection;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import java.util.Optional;
import net.kyori.adventure.text.serializer.legacytext3.LegacyText3ComponentSerializer;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PreLoginEvent
implements ResultedEvent<PreLoginComponentResult> {
    private final InboundConnection connection;
    private final String username;
    private PreLoginComponentResult result;

    public PreLoginEvent(InboundConnection connection, String username) {
        this.connection = (InboundConnection)Preconditions.checkNotNull((Object)connection, (Object)"connection");
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        this.result = PreLoginComponentResult.allowed();
    }

    public InboundConnection getConnection() {
        return this.connection;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public PreLoginComponentResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull PreLoginComponentResult result) {
        this.result = (PreLoginComponentResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public String toString() {
        return "PreLoginEvent{connection=" + this.connection + ", username='" + this.username + '\'' + ", result=" + this.result + '}';
    }

    public static final class PreLoginComponentResult
    implements ResultedEvent.Result {
        private static final PreLoginComponentResult ALLOWED = new PreLoginComponentResult(Result.ALLOWED, null);
        private static final PreLoginComponentResult FORCE_ONLINEMODE = new PreLoginComponentResult(Result.FORCE_ONLINE, null);
        private static final PreLoginComponentResult FORCE_OFFLINEMODE = new PreLoginComponentResult(Result.FORCE_OFFLINE, null);
        private final Result result;
        private final net.kyori.adventure.text.Component reason;

        private PreLoginComponentResult(Result result, @Nullable net.kyori.adventure.text.Component reason) {
            this.result = result;
            this.reason = reason;
        }

        @Override
        public boolean isAllowed() {
            return this.result != Result.DISALLOWED;
        }

        @Deprecated
        public Optional<Component> getReason() {
            return Optional.ofNullable(this.reason).map(arg_0 -> ((LegacyText3ComponentSerializer)LegacyText3ComponentSerializer.get()).serialize(arg_0));
        }

        public Optional<net.kyori.adventure.text.Component> getReasonComponent() {
            return Optional.ofNullable(this.reason);
        }

        public boolean isOnlineModeAllowed() {
            return this.result == Result.FORCE_ONLINE;
        }

        public boolean isForceOfflineMode() {
            return this.result == Result.FORCE_OFFLINE;
        }

        public String toString() {
            switch (this.result) {
                case ALLOWED: {
                    return "allowed";
                }
                case FORCE_OFFLINE: {
                    return "allowed with force offline mode";
                }
                case FORCE_ONLINE: {
                    return "allowed with online mode";
                }
            }
            return "denied";
        }

        public static PreLoginComponentResult allowed() {
            return ALLOWED;
        }

        public static PreLoginComponentResult forceOnlineMode() {
            return FORCE_ONLINEMODE;
        }

        public static PreLoginComponentResult forceOfflineMode() {
            return FORCE_OFFLINEMODE;
        }

        @Deprecated
        public static PreLoginComponentResult denied(Component reason) {
            Preconditions.checkNotNull((Object)reason, (Object)"reason");
            return new PreLoginComponentResult(Result.DISALLOWED, LegacyText3ComponentSerializer.get().deserialize(reason));
        }

        public static PreLoginComponentResult denied(net.kyori.adventure.text.Component reason) {
            Preconditions.checkNotNull((Object)reason, (Object)"reason");
            return new PreLoginComponentResult(Result.DISALLOWED, reason);
        }

        private static enum Result {
            ALLOWED,
            FORCE_ONLINE,
            FORCE_OFFLINE,
            DISALLOWED;

        }
    }
}

