/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Favicon {
    private final String base64Url;

    public Favicon(String base64Url) {
        this.base64Url = (String)Preconditions.checkNotNull((Object)base64Url, (Object)"base64Url");
    }

    public String getBase64Url() {
        return this.base64Url;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Favicon favicon = (Favicon)o;
        return Objects.equals(this.base64Url, favicon.base64Url);
    }

    public int hashCode() {
        return Objects.hash(this.base64Url);
    }

    public String toString() {
        return "Favicon{base64Url='" + this.base64Url + '\'' + '}';
    }

    public static Favicon create(BufferedImage image) {
        Preconditions.checkNotNull((Object)image, (Object)"image");
        Preconditions.checkArgument((image.getWidth() == 64 && image.getHeight() == 64 ? 1 : 0) != 0, (String)"Image is not 64x64 (found %sx%s)", (int)image.getWidth(), (int)image.getHeight());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", os);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new Favicon("data:image/png;base64," + Base64.getEncoder().encodeToString(os.toByteArray()));
    }

    public static Favicon create(Path path) throws IOException {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            BufferedImage image = ImageIO.read(stream);
            if (image == null) {
                throw new IOException("Unable to read the image.");
            }
            Favicon favicon = Favicon.create(image);
            return favicon;
        }
    }
}

