/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public class ServerLoginPluginMessageEvent
implements ResultedEvent<ResponseResult> {
    private final ServerConnection connection;
    private final ChannelIdentifier identifier;
    private final byte[] contents;
    private final int sequenceId;
    private ResponseResult result;

    public ServerLoginPluginMessageEvent(ServerConnection connection, ChannelIdentifier identifier, byte[] contents, int sequenceId) {
        this.connection = (ServerConnection)Preconditions.checkNotNull((Object)connection, (Object)"connection");
        this.identifier = (ChannelIdentifier)Preconditions.checkNotNull((Object)identifier, (Object)"identifier");
        this.contents = (byte[])Preconditions.checkNotNull((Object)contents, (Object)"contents");
        this.sequenceId = sequenceId;
        this.result = ResponseResult.UNKNOWN;
    }

    @Override
    public ResponseResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(ResponseResult result) {
        this.result = (ResponseResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public ChannelIdentifier getIdentifier() {
        return this.identifier;
    }

    public byte[] getContents() {
        return (byte[])this.contents.clone();
    }

    public ByteArrayInputStream contentsAsInputStream() {
        return new ByteArrayInputStream(this.contents);
    }

    public ByteArrayDataInput contentsAsDataStream() {
        return ByteStreams.newDataInput((byte[])this.contents);
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public String toString() {
        return "ServerLoginPluginMessageEvent{connection=" + String.valueOf(this.connection) + ", identifier=" + String.valueOf(this.identifier) + ", sequenceId=" + this.sequenceId + ", contents=" + BaseEncoding.base16().encode(this.contents) + ", result=" + String.valueOf(this.result) + "}";
    }

    public static class ResponseResult
    implements ResultedEvent.Result {
        private static final ResponseResult UNKNOWN = new ResponseResult(null);
        private final byte @Nullable [] response;

        private ResponseResult(byte @Nullable [] response) {
            this.response = response;
        }

        @Override
        public boolean isAllowed() {
            return this.response != null;
        }

        public byte[] getResponse() {
            if (this.response == null) {
                throw new IllegalStateException("Fetching response of unknown message result");
            }
            return (byte[])this.response.clone();
        }

        public static ResponseResult unknown() {
            return UNKNOWN;
        }

        public static ResponseResult reply(byte[] response) {
            Preconditions.checkNotNull((Object)response, (Object)"response");
            return new ResponseResult(response);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResponseResult that = (ResponseResult)o;
            return Arrays.equals(this.response, that.response);
        }

        public int hashCode() {
            return Arrays.hashCode(this.response);
        }

        public String toString() {
            return "ResponseResult{response=" + (this.response == null ? "none" : BaseEncoding.base16().encode(this.response)) + "}";
        }
    }
}

