/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.messages;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LegacyChannelIdentifier
implements ChannelIdentifier {
    private final String name;

    public LegacyChannelIdentifier(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"provided name is empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (legacy)";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyChannelIdentifier that = (LegacyChannelIdentifier)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String getId() {
        return this.getName();
    }
}

