/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.scheduler;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.NotNull;

public interface Scheduler {
    public TaskBuilder buildTask(@NotNull Object var1, @NotNull Runnable var2);

    public TaskBuilder buildTask(@NotNull Object var1, @NotNull Consumer<ScheduledTask> var2);

    @NotNull
    public Collection<ScheduledTask> tasksByPlugin(@NotNull Object var1);

    public static interface TaskBuilder {
        public TaskBuilder delay(@IntRange(from=0L) long var1, @NotNull TimeUnit var3);

        default public TaskBuilder delay(@NotNull Duration duration) {
            return this.delay(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public TaskBuilder repeat(@IntRange(from=0L) long var1, @NotNull TimeUnit var3);

        default public TaskBuilder repeat(@NotNull Duration duration) {
            return this.repeat(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public TaskBuilder clearDelay();

        public TaskBuilder clearRepeat();

        public ScheduledTask schedule();
    }
}

