/*
 * Decompiled with CFR 0.152.
 */
package de.iani.playerUUIDCache.util.fetcher;

import com.destroystokyo.paper.profile.ProfileProperty;
import de.iani.playerUUIDCache.CachedPlayerProfile;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ProfileFetcher
implements Callable<CachedPlayerProfile> {
    private static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final String PROFILE_URL2 = "?unsigned=false";
    private final JSONParser jsonParser = new JSONParser();
    private final UUID uuid;

    public ProfileFetcher(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public CachedPlayerProfile call() throws Exception {
        String id = this.uuid.toString().replace("-", "");
        HttpURLConnection connection = (HttpURLConnection)new URL(PROFILE_URL + id + PROFILE_URL2).openConnection();
        connection.setConnectTimeout(5000);
        JSONObject response = (JSONObject)this.jsonParser.parse((Reader)new InputStreamReader(connection.getInputStream()));
        String id2 = (String)response.get((Object)"id");
        if (!Objects.equals(id, id2)) {
            return null;
        }
        LinkedHashSet<ProfileProperty> propertiesSet = new LinkedHashSet<ProfileProperty>();
        JSONArray properties = (JSONArray)response.get((Object)"properties");
        int l = properties.size();
        for (int i = 0; i < l; ++i) {
            JSONObject property = (JSONObject)properties.get(i);
            String name = (String)property.get((Object)"name");
            String value = (String)property.get((Object)"value");
            String signature = (String)property.get((Object)"signature");
            propertiesSet.add(new ProfileProperty(name, value, signature));
        }
        long now = System.currentTimeMillis();
        return new CachedPlayerProfile(this.uuid, propertiesSet, now, now);
    }
}

