/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.minequery;

import de.minebench.minequery.MinequeryPlugin;
import de.minebench.minequery.Request;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class QueryServer
extends Thread {
    private final MinequeryPlugin plugin;
    private final ServerSocket listener;

    public QueryServer(MinequeryPlugin plugin, String host, int port) throws IOException {
        InetSocketAddress address;
        this.plugin = plugin;
        if (host.equalsIgnoreCase("ANY")) {
            plugin.getLogger().info("Starting server on *:" + Integer.toString(port));
            address = new InetSocketAddress(port);
        } else {
            plugin.getLogger().info("Starting server on " + host + ":" + Integer.toString(port));
            address = new InetSocketAddress(host, port);
        }
        this.listener = new ServerSocket();
        this.listener.bind(address);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket socket = this.listener.accept();
                new Thread(new Request(this.plugin, socket)).start();
            }
        }
        catch (IOException ex) {
            this.plugin.getLogger().info("Stopping server");
            return;
        }
    }

    public ServerSocket getListener() {
        return this.listener;
    }
}

