/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.minequery;

import de.minebench.minequery.MinequeryPlugin;
import de.minebench.minequery.QueryData;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Request
extends Thread {
    private final MinequeryPlugin plugin;
    private final Socket socket;
    private static final char SEPARATOR = ' ';
    private Type type = null;
    private boolean authenticated = false;
    private List<String> input = new ArrayList<String>();

    public Request(MinequeryPlugin plugin, Socket socket) {
        this.plugin = plugin;
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            this.parseRequest();
            this.handleRequest();
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, this.socket.getInetAddress().getHostAddress() + " tried to request '" + (Object)((Object)this.type) + "' which is not supported?");
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Exception while handling request", ex);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseRequest() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        String[] parts = line.split(Pattern.quote(String.valueOf(' ')));
        this.type = Type.valueOf(parts[0].toUpperCase());
        int contentIndex = 1;
        if (this.type.requiresAuthentication) {
            if (this.plugin.getPassword().isEmpty()) {
                this.plugin.log(this.socket.getInetAddress().getHostAddress() + " tried to request '" + (Object)((Object)this.type) + "' which requires authentication but no password was set!");
            } else if (parts.length > 1 && parts[1].equals(this.plugin.getPassword())) {
                this.authenticated = true;
            } else {
                this.plugin.log(this.socket.getInetAddress().getHostAddress() + " tried to request '" + (Object)((Object)this.type) + "' but did not authenticate!");
            }
            contentIndex = 2;
        }
        StringBuilder quoted = null;
        for (int i = contentIndex; i < parts.length; ++i) {
            if (quoted != null) {
                if (parts[i].endsWith("\"")) {
                    this.input.add(quoted.toString() + ' ' + parts[i].substring(0, parts[i].length() - 1));
                    quoted = null;
                    continue;
                }
                quoted.append(' ').append(parts[i]);
                continue;
            }
            if (parts[i].startsWith("\"")) {
                if (parts[i].endsWith("\"")) {
                    this.input.add(parts[i].substring(1, parts[i].length() - 1));
                    continue;
                }
                quoted = new StringBuilder(parts[i].substring(1));
                continue;
            }
            this.input.add(parts[i]);
        }
        if (this.type.inputLength >= 0 && this.input.size() != this.type.inputLength) {
            this.plugin.log(this.socket.getInetAddress().getHostAddress() + " tried to request '" + (Object)((Object)this.type) + "' but did not provide enough input parameters! (Requires " + this.type.inputLength + ")");
        }
    }

    private void handleRequest() throws IOException {
        if (this.type == null) {
            return;
        }
        this.plugin.log(this.socket.getInetAddress().getHostAddress() + " - '" + (Object)((Object)this.type) + "' - " + this.authenticated + (this.input.isEmpty() ? "" : " - ['" + String.join((CharSequence)"','", this.input) + "']"));
        if (this.type.requiresAuthentication && !this.authenticated) {
            return;
        }
        ArrayList<String> responseList = new ArrayList<String>();
        switch (this.type) {
            case QUERY: 
            case QUERY_JSON: {
                QueryData queryData = this.plugin.getQueryData(this.socket);
                if (queryData.disconnected != null) {
                    DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
                    out.writeBytes(queryData.disconnected);
                    return;
                }
                int onlinePlayers = queryData.getOnline();
                if (onlinePlayers > queryData.getNameList().size()) {
                    onlinePlayers = queryData.getNameList().size();
                }
                Response response = new Response(this.plugin.getListenerPort(), queryData.getNameList(), queryData.getUuidList(), onlinePlayers, queryData.getMaxPlayers());
                if (this.type == Type.QUERY_JSON) {
                    responseList.add(response.toJson());
                    break;
                }
                responseList.add(response.toString());
                break;
            }
            case COMMAND: {
                for (String command : this.input) {
                    responseList.add("COMMAND:" + command);
                    responseList.addAll(this.plugin.executeCommand(command));
                }
                break;
            }
            case PLAYER_COMMAND: {
                for (String command : this.input) {
                    String[] parts = command.split(":", 2);
                    responseList.add("PLAYER_COMMAND:" + command + ":" + this.plugin.executeCommand(parts[0], parts[1]));
                }
                break;
            }
            default: {
                this.plugin.getLogger().log(Level.WARNING, this.socket.getInetAddress().getHostAddress() + " tried to request '" + (Object)((Object)this.type) + "' which is not supported?");
            }
        }
        if (!responseList.isEmpty()) {
            DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
            for (String s : responseList) {
                out.writeBytes(s + "\n");
            }
        }
    }

    public class Response {
        private final int serverPort;
        private final List<String> playerList;
        private final List<UUID> uuidList;
        private final int onlineCount;
        private final int maxPlayers;

        public Response(int serverPort, List<String> playerList, List<UUID> uuidList, int onlineCount, int maxPlayers) {
            this.serverPort = serverPort;
            this.playerList = playerList;
            this.uuidList = uuidList;
            this.onlineCount = onlineCount;
            this.maxPlayers = maxPlayers;
        }

        public String toString() {
            return "SERVERPORT " + this.serverPort + "\nPLAYERCOUNT " + this.onlineCount + "\nMAXPLAYERS " + this.maxPlayers + "\nPLAYERLIST " + Arrays.toString(this.playerList.toArray()) + "\nUUIDLIST " + Arrays.toString(this.uuidList.toArray()) + "";
        }

        public String toJson() {
            return "{\"serverPort\":" + this.serverPort + ",\"playerCount\":" + this.onlineCount + ",\"maxPlayers\":" + this.maxPlayers + ",\"playerList\":[" + this.playerList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(",")) + "],\"uuidList\":[" + this.uuidList.stream().map(u -> "\"" + u.toString() + "\"").collect(Collectors.joining(",")) + "]}";
        }
    }

    public static enum Type {
        QUERY,
        QUERY_JSON,
        COMMAND(true, -1),
        PLAYER_COMMAND(true, -1);

        private final boolean requiresAuthentication;
        private final int inputLength;

        private Type() {
            this(false, 0);
        }

        private Type(boolean requiresAuthentication, int inputLength) {
            this.requiresAuthentication = requiresAuthentication;
            this.inputLength = inputLength;
        }
    }
}

