/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.minequery.bukkit;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.StatusClient;
import de.minebench.minequery.MinequeryPlugin;
import de.minebench.minequery.QueryData;
import de.minebench.minequery.QueryServer;
import de.minebench.minequery.bukkit.BukkitQuerySender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Minequery
extends JavaPlugin
implements MinequeryPlugin,
Listener {
    public static final String CONFIG_FILE = "minequery.properties";
    private String serverIP;
    private int port;
    private QueryServer server;
    private String password;
    private boolean logging;
    private Set<String> includedWorlds;
    private Set<String> hiddenWorlds;

    public void onEnable() {
        this.load();
    }

    private void load() {
        try {
            Properties props;
            File dir = this.getDataFolder();
            File file = new File(dir, CONFIG_FILE);
            if (!dir.exists() || !file.exists()) {
                dir.mkdirs();
                this.getLogger().log(Level.INFO, "Generate config");
                props = new Properties();
                props.setProperty("server-ip", "127.0.0.1");
                props.setProperty("minequery-port", "25566");
                props.setProperty("password", "");
                props.setProperty("logging", "true");
                props.setProperty("included-worlds", "*");
                props.setProperty("hidden-worlds", "hidden1,hidden2");
                FileOutputStream out = new FileOutputStream(file);
                props.store(out, "Minequery settings");
            }
            props = new Properties();
            props.load(new FileReader(file));
            this.serverIP = props.getProperty("server-ip", "SELF");
            if (this.serverIP.isEmpty() || this.serverIP.equalsIgnoreCase("SELF")) {
                this.serverIP = this.getServer().getIp();
            }
            this.port = Integer.parseInt(props.getProperty("minequery-port", "25566"));
            this.password = props.getProperty("password", "");
            this.logging = Boolean.parseBoolean(props.getProperty("logging", "true"));
            this.includedWorlds = new HashSet<String>(Arrays.asList(props.getProperty("included-worlds", "*").toLowerCase().split(",")));
            this.hiddenWorlds = new HashSet<String>(Arrays.asList(props.getProperty("hidden-worlds", "").toLowerCase().split(",")));
            if (this.serverIP.equals("")) {
                this.serverIP = "ANY";
            }
            if (this.password.isEmpty()) {
                this.getLogger().log(Level.WARNING, "No password is set! Requests that require authentication will not work!");
            }
            this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error initializing Minequery", ex);
        }
    }

    @EventHandler
    public void onServerLoaded(ServerLoadEvent event) {
        try {
            if (event.getType() == ServerLoadEvent.LoadType.RELOAD && this.server != null) {
                this.server.getListener().close();
                this.server.interrupt();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error stopping Minequery server", ex);
        }
        try {
            this.server = new QueryServer(this, this.serverIP, this.port);
            this.server.start();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error initializing Minequery Server", ex);
        }
    }

    public void onDisable() {
        try {
            if (this.server != null) {
                this.server.getListener().close();
                this.server.interrupt();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Unable to close the Minequery listener", ex);
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isIncluded(String name) {
        boolean isIncluded = this.includedWorlds.isEmpty() || this.includedWorlds.contains("*") || this.includedWorlds.contains(name.toLowerCase());
        return isIncluded && !this.hiddenWorlds.contains(name.toLowerCase());
    }

    @Override
    public void log(String message) {
        if (this.logging) {
            this.getLogger().log(Level.INFO, message);
        }
    }

    @Override
    public int getListenerPort() {
        return this.getServer().getPort();
    }

    @Override
    public QueryData getQueryData(final Socket socket) {
        QueryData data = new QueryData();
        PaperServerListPingEvent pingEvent = new PaperServerListPingEvent(new StatusClient(){

            public InetSocketAddress getAddress() {
                return new InetSocketAddress(socket.getInetAddress(), socket.getPort());
            }

            public int getProtocolVersion() {
                return 0;
            }

            public InetSocketAddress getVirtualHost() {
                return null;
            }
        }, this.getServer().getMotd(), this.getServer().getOnlinePlayers().size(), this.getServer().getMaxPlayers(), this.getName(), 0, null);
        this.getServer().getPluginManager().callEvent((Event)pingEvent);
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (player.getServer() == null || !this.isIncluded(player.getWorld().getName())) continue;
            data.getNameList().add(player.getName());
            data.getUuidList().add(player.getUniqueId());
        }
        data.setOnline(pingEvent.getNumPlayers());
        data.setMaxPlayers(pingEvent.getMaxPlayers());
        return data;
    }

    @Override
    public QueryServer getQueryServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> executeCommand(String command) {
        BukkitQuerySender querySender = new BukkitQuerySender(this);
        this.getLogger().info("Executing: " + command);
        Object pauseLock = new Object();
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            Object object = pauseLock;
            synchronized (object) {
                this.getServer().dispatchCommand((CommandSender)querySender, command);
                pauseLock.notify();
            }
        });
        Object object = pauseLock;
        synchronized (object) {
            try {
                pauseLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return querySender.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand(String player, String command) {
        Player p = this.getServer().getPlayer(player);
        if (p == null && player.length() == 36) {
            try {
                p = this.getServer().getPlayer(UUID.fromString(player));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.WARNING, player + " is not a valid UUID!");
            }
        }
        if (p != null) {
            this.getLogger().info("Making " + p.getName() + " execute:" + command);
            AtomicReference<Object> r = new AtomicReference<Object>(null);
            Player finalP = p;
            Object pauseLock = new Object();
            this.getServer().getScheduler().runTask((Plugin)this, () -> {
                Object object = pauseLock;
                synchronized (object) {
                    r.set(this.getServer().dispatchCommand((CommandSender)finalP, command));
                    pauseLock.notify();
                }
            });
            Object object = pauseLock;
            synchronized (object) {
                try {
                    pauseLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return r.get() != null && (Boolean)r.get() != false;
        }
        return false;
    }
}

