/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.minequery.bungee;

import de.minebench.minequery.MinequeryPlugin;
import de.minebench.minequery.QueryData;
import de.minebench.minequery.QueryServer;
import de.minebench.minequery.bungee.BungeeQuerySender;
import de.minebench.minequery.bungee.QueryPendingConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ProxyReloadEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.event.EventHandler;

public final class Minequery
extends Plugin
implements MinequeryPlugin,
Listener {
    public static final String CONFIG_FILE = "minequery.properties";
    private String serverIP;
    private int port;
    private QueryServer server;
    private String password;
    private boolean logging;
    private Set<String> includedServers;
    private Set<String> hiddenServers;
    private ScheduledTask serverTask;
    private ListenerInfo info;

    public void onEnable() {
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.load();
    }

    private void load() {
        this.info = (ListenerInfo)this.getProxy().getConfig().getListeners().iterator().next();
        try {
            Properties props;
            File dir = this.getDataFolder();
            File file = new File(dir, CONFIG_FILE);
            if (!dir.exists() || !file.exists()) {
                dir.mkdirs();
                this.getLogger().log(Level.INFO, "Generate config");
                props = new Properties();
                props.setProperty("server-ip", "127.0.0.1");
                props.setProperty("minequery-port", "25566");
                props.setProperty("password", "");
                props.setProperty("logging", "true");
                props.setProperty("included-servers", "*");
                props.setProperty("hidden-servers", "hidden1,hidden2");
                FileOutputStream out = new FileOutputStream(file);
                props.store(out, "Minequery settings");
            }
            props = new Properties();
            props.load(new FileReader(file));
            this.serverIP = props.getProperty("server-ip", "SELF");
            if (this.serverIP.isEmpty() || this.serverIP.equalsIgnoreCase("SELF")) {
                this.serverIP = this.info.getHost().getAddress().getHostAddress();
            }
            this.port = Integer.parseInt(props.getProperty("minequery-port", "25566"));
            this.password = props.getProperty("password", "");
            this.logging = Boolean.parseBoolean(props.getProperty("logging", "true"));
            this.includedServers = new HashSet<String>(Arrays.asList(props.getProperty("included-servers", "*").toLowerCase().split(",")));
            this.hiddenServers = new HashSet<String>(Arrays.asList(props.getProperty("hidden-servers", "").toLowerCase().split(",")));
            if (this.serverIP.equals("")) {
                this.serverIP = "ANY";
            }
            this.server = new QueryServer(this, this.serverIP, this.port);
            this.serverTask = this.getProxy().getScheduler().runAsync((Plugin)this, (Runnable)this.server);
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Error initializing Minequery", ex);
        }
    }

    @EventHandler
    public void onReload(ProxyReloadEvent event) {
        this.onDisable();
        this.load();
    }

    public void onDisable() {
        try {
            if (this.server != null) {
                this.server.getListener().close();
            }
            if (this.serverTask != null) {
                this.serverTask.cancel();
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Unable to close the Minequery listener", ex);
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isIncluded(String name) {
        boolean isIncluded = this.includedServers.isEmpty() || this.includedServers.contains("*") || this.includedServers.contains(name.toLowerCase());
        return isIncluded && !this.hiddenServers.contains(name.toLowerCase());
    }

    @Override
    public void log(String message) {
        if (this.logging) {
            this.getLogger().log(Level.INFO, message);
        }
    }

    @Override
    public int getListenerPort() {
        return this.info.getHost().getPort();
    }

    @Override
    public QueryData getQueryData(Socket socket) {
        QueryPendingConnection data = new QueryPendingConnection(this, socket);
        ProxyPingEvent pingEvent = new ProxyPingEvent((PendingConnection)data, new ServerPing(new ServerPing.Protocol(this.getDescription().getName(), 0), new ServerPing.Players(this.info.getMaxPlayers(), this.getProxy().getOnlineCount(), new ServerPing.PlayerInfo[0]), this.info.getMotd(), ""), (result, error) -> {});
        this.getProxy().getPluginManager().callEvent((Event)pingEvent);
        for (ProxiedPlayer player : this.getProxy().getPlayers()) {
            if (player.getServer() == null || !this.isIncluded(player.getServer().getInfo().getName())) continue;
            data.getNameList().add(player.getName());
            data.getUuidList().add(player.getUniqueId());
        }
        data.setOnline(pingEvent.getResponse().getPlayers().getOnline());
        data.setMaxPlayers(pingEvent.getResponse().getPlayers().getMax());
        return data;
    }

    @Override
    public QueryServer getQueryServer() {
        return this.server;
    }

    @Override
    public List<String> executeCommand(String command) {
        BungeeQuerySender querySender = new BungeeQuerySender(this);
        this.getLogger().info("Executing: " + command);
        this.getProxy().getPluginManager().dispatchCommand((CommandSender)querySender, command);
        return querySender.getResponse();
    }

    @Override
    public boolean executeCommand(String player, String command) {
        ProxiedPlayer p = this.getProxy().getPlayer(player);
        if (p == null && player.length() == 36) {
            try {
                p = this.getProxy().getPlayer(UUID.fromString(player));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.WARNING, player + " is not a valid UUID!");
            }
        }
        if (p != null) {
            this.getLogger().info("Making " + p.getName() + " execute:" + command);
            return this.getProxy().getPluginManager().dispatchCommand((CommandSender)p, command);
        }
        return false;
    }

    public ListenerInfo getListenerInfo() {
        return this.info;
    }
}

