/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.destroystokyo.paper.HeightmapType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface World
extends PluginMessageRecipient,
Metadatable {
    public int getEntityCount();

    public int getTileEntityCount();

    public int getTickableTileEntityCount();

    public int getChunkCount();

    public int getPlayerCount();

    @NotNull
    public Block getBlockAt(int var1, int var2, int var3);

    @NotNull
    public Block getBlockAt(@NotNull Location var1);

    @NotNull
    default public Block getBlockAtKey(long key) {
        int x = Block.getBlockKeyX(key);
        int y = Block.getBlockKeyY(key);
        int z = Block.getBlockKeyZ(key);
        return this.getBlockAt(x, y, z);
    }

    @NotNull
    default public Location getLocationAtKey(long key) {
        int x = Block.getBlockKeyX(key);
        int y = Block.getBlockKeyY(key);
        int z = Block.getBlockKeyZ(key);
        return new Location(this, x, y, z);
    }

    public int getHighestBlockYAt(int var1, int var2);

    public int getHighestBlockYAt(@NotNull Location var1);

    @NotNull
    public Block getHighestBlockAt(int var1, int var2);

    @NotNull
    public Block getHighestBlockAt(@NotNull Location var1);

    public int getHighestBlockYAt(int var1, int var2, @NotNull HeightmapType var3) throws UnsupportedOperationException;

    default public int getHighestBlockYAt(@NotNull Location location, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightmap);
    }

    @NotNull
    default public Block getHighestBlockAt(int x, int z, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightmap), z);
    }

    @NotNull
    default public Block getHighestBlockAt(@NotNull Location location, @NotNull HeightmapType heightmap) throws UnsupportedOperationException {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightmap);
    }

    @NotNull
    public Chunk getChunkAt(int var1, int var2);

    @NotNull
    public Chunk getChunkAt(@NotNull Location var1);

    @NotNull
    public Chunk getChunkAt(@NotNull Block var1);

    @NotNull
    default public Chunk getChunkAt(long chunkKey) {
        return this.getChunkAt((int)chunkKey, (int)(chunkKey >> 32));
    }

    default public boolean isChunkGenerated(long chunkKey) {
        return this.isChunkGenerated((int)chunkKey, (int)(chunkKey >> 32));
    }

    @Deprecated
    default public void getChunkAtAsync(int x, int z, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(x, z, true).thenAccept(cb::onLoad);
    }

    @Deprecated
    default public void getChunkAtAsync(@NotNull Location loc, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(loc, true).thenAccept(cb::onLoad);
    }

    @Deprecated
    default public void getChunkAtAsync(@NotNull Block block, @NotNull ChunkLoadCallback cb) {
        this.getChunkAtAsync(block, true).thenAccept(cb::onLoad);
    }

    default public void getChunkAtAsync(int x, int z, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync(x, z, true).thenAccept((java.util.function.Consumer)cb);
    }

    default public void getChunkAtAsync(int x, int z, boolean gen, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync(x, z, gen).thenAccept((java.util.function.Consumer)cb);
    }

    default public void getChunkAtAsync(@NotNull Location loc, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, true, cb);
    }

    default public void getChunkAtAsync(@NotNull Location loc, boolean gen, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, gen, cb);
    }

    default public void getChunkAtAsync(@NotNull Block block, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, true, cb);
    }

    default public void getChunkAtAsync(@NotNull Block block, boolean gen, @NotNull java.util.function.Consumer<Chunk> cb) {
        this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, gen, cb);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Location loc) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Location loc, boolean gen) {
        return this.getChunkAtAsync((int)Math.floor(loc.getX()) >> 4, (int)Math.floor(loc.getZ()) >> 4, gen);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Block block) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, true);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(@NotNull Block block, boolean gen) {
        return this.getChunkAtAsync(block.getX() >> 4, block.getZ() >> 4, gen);
    }

    @NotNull
    default public CompletableFuture<Chunk> getChunkAtAsync(int x, int z) {
        return this.getChunkAtAsync(x, z, true);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(int var1, int var2, boolean var3);

    public boolean isChunkLoaded(@NotNull Chunk var1);

    @NotNull
    public Chunk[] getLoadedChunks();

    public void loadChunk(@NotNull Chunk var1);

    public boolean isChunkLoaded(int var1, int var2);

    public boolean isChunkGenerated(int var1, int var2);

    @Deprecated
    public boolean isChunkInUse(int var1, int var2);

    public void loadChunk(int var1, int var2);

    public boolean loadChunk(int var1, int var2, boolean var3);

    public boolean unloadChunk(@NotNull Chunk var1);

    public boolean unloadChunk(int var1, int var2);

    public boolean unloadChunk(int var1, int var2, boolean var3);

    public boolean unloadChunkRequest(int var1, int var2);

    @Deprecated
    public boolean regenerateChunk(int var1, int var2);

    @Deprecated
    public boolean refreshChunk(int var1, int var2);

    public boolean isChunkForceLoaded(int var1, int var2);

    public void setChunkForceLoaded(int var1, int var2, boolean var3);

    @NotNull
    public Collection<Chunk> getForceLoadedChunks();

    public boolean addPluginChunkTicket(int var1, int var2, @NotNull Plugin var3);

    public boolean removePluginChunkTicket(int var1, int var2, @NotNull Plugin var3);

    public void removePluginChunkTickets(@NotNull Plugin var1);

    @NotNull
    public Collection<Plugin> getPluginChunkTickets(int var1, int var2);

    @NotNull
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets();

    @NotNull
    public Item dropItem(@NotNull Location var1, @NotNull ItemStack var2);

    @NotNull
    public Item dropItemNaturally(@NotNull Location var1, @NotNull ItemStack var2);

    @NotNull
    public Arrow spawnArrow(@NotNull Location var1, @NotNull Vector var2, float var3, float var4);

    @NotNull
    public <T extends AbstractArrow> T spawnArrow(@NotNull Location var1, @NotNull Vector var2, float var3, float var4, @NotNull Class<T> var5);

    public boolean generateTree(@NotNull Location var1, @NotNull TreeType var2);

    public boolean generateTree(@NotNull Location var1, @NotNull TreeType var2, @NotNull BlockChangeDelegate var3);

    @NotNull
    public Entity spawnEntity(@NotNull Location var1, @NotNull EntityType var2);

    @NotNull
    public LightningStrike strikeLightning(@NotNull Location var1);

    @NotNull
    public LightningStrike strikeLightningEffect(@NotNull Location var1);

    @NotNull
    public List<Entity> getEntities();

    @NotNull
    public List<LivingEntity> getLivingEntities();

    @Deprecated
    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... var1);

    @NotNull
    public <T extends Entity> Collection<T> getEntitiesByClass(@NotNull Class<T> var1);

    @NotNull
    public Collection<Entity> getEntitiesByClasses(Class<?> ... var1);

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double radius, @Nullable Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public Collection<LivingEntity> getNearbyLivingEntities(@NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<LivingEntity> predicate) {
        return this.getNearbyEntitiesByType(LivingEntity.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double radius, @Nullable Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public Collection<Player> getNearbyPlayers(@NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<Player> predicate) {
        return this.getNearbyEntitiesByType(Player.class, loc, xRadius, yRadius, zRadius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double radius) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xzRadius, double yRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xRadius, double yRadius, double zRadius) {
        return this.getNearbyEntitiesByType(clazz, loc, xRadius, yRadius, zRadius, null);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double radius, @Nullable Predicate<T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, radius, radius, radius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends T> clazz, @NotNull Location loc, double xzRadius, double yRadius, @Nullable Predicate<T> predicate) {
        return this.getNearbyEntitiesByType(clazz, loc, xzRadius, yRadius, xzRadius, predicate);
    }

    @NotNull
    default public <T extends Entity> Collection<T> getNearbyEntitiesByType(@Nullable Class<? extends Entity> clazz, @NotNull Location loc, double xRadius, double yRadius, double zRadius, @Nullable Predicate<T> predicate) {
        if (clazz == null) {
            clazz = Entity.class;
        }
        ArrayList<Entity> nearby = new ArrayList<Entity>();
        for (Entity bukkitEntity : this.getNearbyEntities(loc, xRadius, yRadius, zRadius)) {
            if (!clazz.isAssignableFrom(bukkitEntity.getClass()) || predicate != null && !predicate.test(bukkitEntity)) continue;
            nearby.add(bukkitEntity);
        }
        return nearby;
    }

    @NotNull
    public List<Player> getPlayers();

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Location var1, double var2, double var4, double var6);

    @Nullable
    public Entity getEntity(@NotNull UUID var1);

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull Location var1, double var2, double var4, double var6, @Nullable Predicate<Entity> var8);

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull BoundingBox var1);

    @NotNull
    public Collection<Entity> getNearbyEntities(@NotNull BoundingBox var1, @Nullable Predicate<Entity> var2);

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Location var1, @NotNull Vector var2, double var3);

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Location var1, @NotNull Vector var2, double var3, double var5);

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Location var1, @NotNull Vector var2, double var3, @Nullable Predicate<Entity> var5);

    @Nullable
    public RayTraceResult rayTraceEntities(@NotNull Location var1, @NotNull Vector var2, double var3, double var5, @Nullable Predicate<Entity> var7);

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Location var1, @NotNull Vector var2, double var3);

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Location var1, @NotNull Vector var2, double var3, @NotNull FluidCollisionMode var5);

    @Nullable
    public RayTraceResult rayTraceBlocks(@NotNull Location var1, @NotNull Vector var2, double var3, @NotNull FluidCollisionMode var5, boolean var6);

    @Nullable
    public RayTraceResult rayTrace(@NotNull Location var1, @NotNull Vector var2, double var3, @NotNull FluidCollisionMode var5, boolean var6, double var7, @Nullable Predicate<Entity> var9);

    @NotNull
    public String getName();

    @NotNull
    public UUID getUID();

    @NotNull
    public Location getSpawnLocation();

    @NotNull
    public boolean setSpawnLocation(@NotNull Location var1);

    public boolean setSpawnLocation(int var1, int var2, int var3);

    public long getTime();

    public void setTime(long var1);

    public long getFullTime();

    public void setFullTime(long var1);

    public boolean isDayTime();

    public boolean hasStorm();

    public void setStorm(boolean var1);

    public int getWeatherDuration();

    public void setWeatherDuration(int var1);

    public boolean isThundering();

    public void setThundering(boolean var1);

    public int getThunderDuration();

    public void setThunderDuration(int var1);

    public boolean createExplosion(double var1, double var3, double var5, float var7);

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8);

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8, boolean var9);

    public boolean createExplosion(double var1, double var3, double var5, float var7, boolean var8, boolean var9, @Nullable Entity var10);

    public boolean createExplosion(@NotNull Location var1, float var2);

    public boolean createExplosion(@NotNull Location var1, float var2, boolean var3);

    public boolean createExplosion(@Nullable Entity var1, @NotNull Location var2, float var3, boolean var4, boolean var5);

    default public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power, boolean setFire) {
        return this.createExplosion(source, loc, power, setFire, true);
    }

    default public boolean createExplosion(@Nullable Entity source, @NotNull Location loc, float power) {
        return this.createExplosion(source, loc, power, true, true);
    }

    default public boolean createExplosion(@NotNull Entity source, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(source, source.getLocation(), power, setFire, breakBlocks);
    }

    default public boolean createExplosion(@NotNull Entity source, float power, boolean setFire) {
        return this.createExplosion(source, source.getLocation(), power, setFire, true);
    }

    default public boolean createExplosion(@NotNull Entity source, float power) {
        return this.createExplosion(source, source.getLocation(), power, true, true);
    }

    public boolean createExplosion(@NotNull Location var1, float var2, boolean var3, boolean var4);

    public boolean createExplosion(@NotNull Location var1, float var2, boolean var3, boolean var4, @Nullable Entity var5);

    @NotNull
    public Environment getEnvironment();

    public long getSeed();

    public boolean getPVP();

    public void setPVP(boolean var1);

    @Nullable
    public ChunkGenerator getGenerator();

    public void save();

    @NotNull
    public List<BlockPopulator> getPopulators();

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location var1, @NotNull Class<T> var2) throws IllegalArgumentException;

    @NotNull
    public <T extends Entity> T spawn(@NotNull Location var1, @NotNull Class<T> var2, @Nullable Consumer<T> var3) throws IllegalArgumentException;

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull MaterialData var2) throws IllegalArgumentException;

    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull BlockData var2) throws IllegalArgumentException;

    @Deprecated
    @NotNull
    public FallingBlock spawnFallingBlock(@NotNull Location var1, @NotNull Material var2, byte var3) throws IllegalArgumentException;

    public void playEffect(@NotNull Location var1, @NotNull Effect var2, int var3);

    public void playEffect(@NotNull Location var1, @NotNull Effect var2, int var3, int var4);

    public <T> void playEffect(@NotNull Location var1, @NotNull Effect var2, @Nullable T var3);

    public <T> void playEffect(@NotNull Location var1, @NotNull Effect var2, @Nullable T var3, int var4);

    @NotNull
    public ChunkSnapshot getEmptyChunkSnapshot(int var1, int var2, boolean var3, boolean var4);

    public void setSpawnFlags(boolean var1, boolean var2);

    public boolean getAllowAnimals();

    public boolean getAllowMonsters();

    @NotNull
    public Biome getBiome(int var1, int var2);

    public void setBiome(int var1, int var2, @NotNull Biome var3);

    public double getTemperature(int var1, int var2);

    public double getHumidity(int var1, int var2);

    public int getMaxHeight();

    public int getSeaLevel();

    public boolean getKeepSpawnInMemory();

    public void setKeepSpawnInMemory(boolean var1);

    public boolean isAutoSave();

    public void setAutoSave(boolean var1);

    public void setDifficulty(@NotNull Difficulty var1);

    @NotNull
    public Difficulty getDifficulty();

    @NotNull
    public File getWorldFolder();

    @Nullable
    public WorldType getWorldType();

    public boolean canGenerateStructures();

    public long getTicksPerAnimalSpawns();

    public void setTicksPerAnimalSpawns(int var1);

    public long getTicksPerMonsterSpawns();

    public void setTicksPerMonsterSpawns(int var1);

    public int getMonsterSpawnLimit();

    public void setMonsterSpawnLimit(int var1);

    public int getAnimalSpawnLimit();

    public void setAnimalSpawnLimit(int var1);

    public int getWaterAnimalSpawnLimit();

    public void setWaterAnimalSpawnLimit(int var1);

    public int getAmbientSpawnLimit();

    public void setAmbientSpawnLimit(int var1);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull String var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    @NotNull
    public String[] getGameRules();

    @Deprecated
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public String getGameRuleValue(@Nullable String var1);

    @Deprecated
    public boolean setGameRuleValue(@NotNull String var1, @NotNull String var2);

    public boolean isGameRule(@NotNull String var1);

    @Nullable
    public <T> T getGameRuleValue(@NotNull GameRule<T> var1);

    @Nullable
    public <T> T getGameRuleDefault(@NotNull GameRule<T> var1);

    public <T> boolean setGameRule(@NotNull GameRule<T> var1, @NotNull T var2);

    @NotNull
    public WorldBorder getWorldBorder();

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, @Nullable T var4);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, @Nullable T var9);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, @Nullable T var10);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, @Nullable T var15);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10, @Nullable T var12);

    default public <T> void spawnParticle(@NotNull Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        this.spawnParticle(particle, null, null, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    default public <T> void spawnParticle(@NotNull Particle particle, @Nullable List<Player> receivers, @NotNull Player source, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, @Nullable T data) {
        this.spawnParticle(particle, receivers, source, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, true);
    }

    public <T> void spawnParticle(@NotNull Particle var1, @Nullable List<Player> var2, @Nullable Player var3, double var4, double var6, double var8, int var10, double var11, double var13, double var15, double var17, @Nullable T var19, boolean var20);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10, @Nullable T var12, boolean var13);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, @Nullable T var17, boolean var18);

    @Nullable
    public Location locateNearestStructure(@NotNull Location var1, @NotNull StructureType var2, int var3, boolean var4);

    @NotNull
    public CompletableFuture<Location> locateNearestStructureAsync(@NotNull Location var1, @NotNull StructureType var2, int var3, boolean var4);

    public int getViewDistance();

    @NotNull
    public Spigot spigot();

    @Nullable
    public Raid locateNearestRaid(@NotNull Location var1, int var2);

    @NotNull
    public List<Raid> getRaids();

    public static enum Environment {
        NORMAL(0),
        NETHER(-1),
        THE_END(1);

        private final int id;
        private static final Map<Integer, Environment> lookup;

        private Environment(int id) {
            this.id = id;
        }

        @Deprecated
        public int getId() {
            return this.id;
        }

        @Deprecated
        @Nullable
        public static Environment getEnvironment(int id) {
            return lookup.get(id);
        }

        static {
            lookup = new HashMap<Integer, Environment>();
            for (Environment env : Environment.values()) {
                lookup.put(env.getId(), env);
            }
        }
    }

    public static class Spigot {
        @NotNull
        public LightningStrike strikeLightning(@NotNull Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public LightningStrike strikeLightningEffect(@NotNull Location loc, boolean isSilent) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @Deprecated
    public static interface ChunkLoadCallback
    extends java.util.function.Consumer<Chunk> {
        public void onLoad(@NotNull Chunk var1);

        @Override
        default public void accept(@NotNull Chunk chunk) {
            this.onLoad(chunk);
        }
    }
}

