/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.plotgenerator;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import de.minebench.plotgenerator.PlotGenerator;
import de.minebench.plotgenerator.PlotGeneratorConfig;
import de.minebench.plotgenerator.RegionIntent;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.ChunkGenerator;

public class PlotChunkGenerator
extends ChunkGenerator {
    private final PlotGenerator plugin;
    private final PlotGeneratorConfig config;

    public PlotChunkGenerator() {
        this.plugin = (PlotGenerator)PlotGenerator.getPlugin(PlotGenerator.class);
        this.config = null;
    }

    public PlotChunkGenerator(PlotGenerator plugin, String id) {
        this.plugin = plugin;
        this.config = PlotGeneratorConfig.fromId(plugin, id);
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData data = this.createChunkData(world);
        PlotGeneratorConfig config = this.getConfig(world);
        if (config != null && config.getSchematic() != null && !BlockVector.ZERO.equals((Object)config.getSchematic().getSize())) {
            CuboidClipboard schematic = config.getSchematic();
            BlockVector center = config.getCenter();
            int width = schematic.getWidth() - config.getOverlap();
            int startX = (x * 16 - center.getBlockX()) % width;
            while (startX < 0) {
                startX = width + startX;
            }
            int length = schematic.getLength() - config.getOverlap();
            int startZ = (z * 16 - center.getBlockZ()) % length;
            while (startZ < 0) {
                startZ = length + startZ;
            }
            BlockVector sign = null;
            for (int chunkX = 0; chunkX < 16; ++chunkX) {
                int schemX = (startX + chunkX) % width;
                for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                    int schemZ = (startZ + chunkZ) % length;
                    for (int chunkY = 0; chunkY < schematic.getHeight(); ++chunkY) {
                        BaseBlock block = schematic.getBlock((Vector)new BlockVector(schemX, chunkY, schemZ));
                        data.setBlock(chunkX, chunkY, chunkZ, block.getId(), (byte)block.getData());
                        if ((sign != null || block.getId() != Material.SIGN_POST.getId()) && block.getId() != Material.WALL_SIGN.getId()) continue;
                        sign = new BlockVector(x * 16 + chunkX, chunkY, z * 16 + chunkZ);
                    }
                }
            }
            if (this.plugin.getWorldGuard() != null && config.getRegionId() != null) {
                BlockVector minPoint = new BlockVector(x * 16 - startX + config.getRegionInset(), config.getRegionMinY(), z * 16 - startZ + config.getRegionInset());
                BlockVector maxPoint = new BlockVector(minPoint.getBlockX() + width - 2 * config.getRegionInset(), config.getRegionMaxY(), minPoint.getBlockZ() + length - 2 * config.getRegionInset());
                RegionIntent intent = new RegionIntent(world, config, minPoint, maxPoint);
                if (sign != null) {
                    intent.setSign(sign);
                }
                this.plugin.registerRegionIntent(intent);
            }
        }
        return data;
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        if (this.getConfig(world) == null) {
            return null;
        }
        Location loc = new Location(world, this.getConfig(world).getCenter().getX(), this.getConfig(world).getCenter().getY(), this.getConfig(world).getCenter().getZ());
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load();
        }
        loc.setY((double)world.getHighestBlockYAt(loc));
        return loc;
    }

    public PlotGeneratorConfig getConfig(World world) {
        if (this.config == null) {
            return this.plugin.getGeneratorConfig(world);
        }
        return this.config;
    }
}

