/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.plotgenerator;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import de.minebench.plotgenerator.PlotChunkGenerator;
import de.minebench.plotgenerator.PlotGeneratorConfig;
import de.minebench.plotgenerator.RegionIntent;
import de.minebench.plotgenerator.commands.BuyPlotCommand;
import de.minebench.plotgenerator.commands.PlotGeneratorCommand;
import de.minebench.plotsigns.PlotSigns;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import me.ChrisvA.MbRegionConomy.MbRegionConomy;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlotGenerator
extends JavaPlugin {
    private WorldGuardPlugin worldGuard = null;
    private MbRegionConomy regionConomy = null;
    private PlotSigns plotSigns;
    private Economy economy;
    private File weSchemDir;
    private Map<String, PlotGeneratorConfig> worldConfigs;
    private Map<RegionIntent, Boolean> regionIntents = new ConcurrentHashMap<RegionIntent, Boolean>();
    private Map<String, Integer> regionIds = new HashMap<String, Integer>();
    private int regionCreatorTask = -1;

    public void onEnable() {
        WorldEditPlugin worldEdit = (WorldEditPlugin)WorldEditPlugin.getPlugin(WorldEditPlugin.class);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.weSchemDir = new File(worldEdit.getDataFolder(), "schematics");
        if (!this.weSchemDir.exists()) {
            this.weSchemDir.mkdirs();
        }
        this.loadConfig();
        this.getCommand("plotgenerator").setExecutor((CommandExecutor)new PlotGeneratorCommand(this));
        this.getCommand("buyplot").setExecutor((CommandExecutor)new BuyPlotCommand(this));
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.worldConfigs = new HashMap<String, PlotGeneratorConfig>();
        this.getConfig().getConfigurationSection("worlds").getKeys(false).forEach(this::getGeneratorConfig);
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return new PlotChunkGenerator(this, id);
    }

    public WorldGuardPlugin getWorldGuard() {
        if (this.worldGuard == null && this.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
            this.worldGuard = WorldGuardPlugin.inst();
        }
        return this.worldGuard;
    }

    public MbRegionConomy getRegionConomy() {
        if (this.regionConomy == null && this.getServer().getPluginManager().isPluginEnabled("MbRegionConomy")) {
            this.regionConomy = (MbRegionConomy)MbRegionConomy.getPlugin(MbRegionConomy.class);
        }
        return this.regionConomy;
    }

    public PlotSigns getPlotSigns() {
        if (this.plotSigns == null && this.getServer().getPluginManager().isPluginEnabled("PlotSigns")) {
            this.plotSigns = (PlotSigns)PlotSigns.getPlugin(PlotSigns.class);
        }
        return this.plotSigns;
    }

    public Economy getEconomy() {
        if (this.economy == null) {
            if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
                return null;
            }
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return null;
            }
            this.economy = (Economy)rsp.getProvider();
        }
        return this.economy;
    }

    public CuboidClipboard loadSchematic(String schematicName) {
        if (schematicName == null || schematicName.isEmpty()) {
            return null;
        }
        File file = new File(this.getDataFolder(), schematicName + ".schematic");
        if (!file.exists()) {
            file = new File(this.weSchemDir, schematicName + ".schematic");
        }
        if (!file.exists()) {
            this.getLogger().log(Level.SEVERE, "No schematic found with the name " + schematicName + "!");
            return null;
        }
        SchematicFormat schemFormat = SchematicFormat.getFormat((File)file);
        if (schemFormat == null) {
            this.getLogger().log(Level.SEVERE, "Could not load schematic format from file " + file.getAbsolutePath() + "!");
            return null;
        }
        try {
            return schemFormat.load(file);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Error loading file " + file.getAbsolutePath(), e);
            return null;
        }
    }

    public PlotGeneratorConfig getGeneratorConfig(World world) {
        return this.getGeneratorConfig(world.getName());
    }

    public PlotGeneratorConfig getGeneratorConfig(String worldName) {
        if (this.worldConfigs.containsKey(worldName)) {
            return this.worldConfigs.get(worldName);
        }
        ConfigurationSection config = this.getConfig().getConfigurationSection("worlds." + worldName);
        PlotGeneratorConfig info = PlotGeneratorConfig.fromConfig(this, config);
        if (info != null) {
            this.worldConfigs.put(worldName, info);
        }
        return info;
    }

    public void registerRegionIntent(RegionIntent intent) {
        if (this.regionCreatorTask == -1) {
            this.regionCreatorTask = this.scheduleRegionCreator();
        }
        this.regionIntents.put(intent, true);
    }

    private int scheduleRegionCreator() {
        return this.getServer().getScheduler().runTask((Plugin)this, () -> {
            Iterator<Map.Entry<RegionIntent, Boolean>> intents = this.regionIntents.entrySet().iterator();
            while (intents.hasNext()) {
                RegionIntent intent = intents.next().getKey();
                intents.remove();
                if (this.getWorldGuard() == null) continue;
                RegionManager manager = this.getWorldGuard().getRegionManager(intent.getWorld());
                if (this.testForRegion(intent)) {
                    if (intent.getSign() == null) continue;
                    this.registerBuySign(intent);
                    continue;
                }
                String regionId = this.getNewRegionId(intent);
                ProtectedCuboidRegion region = new ProtectedCuboidRegion(regionId, intent.getMinPoint(), intent.getMaxPoint());
                double tpX = region.getMinimumPoint().getX() + (region.getMaximumPoint().getX() - region.getMinimumPoint().getX()) / 2.0;
                double tpZ = region.getMaximumPoint().getZ();
                double tpY = intent.getWorld().getHighestBlockYAt((int)tpX, (int)tpZ) + 1;
                region.setFlag((Flag)DefaultFlag.TELE_LOC, (Object)new Location(BukkitUtil.getLocalWorld((World)intent.getWorld()), new Vector(tpX, tpY, tpZ), 180.0f, 0.0f));
                if (intent.getConfig().getRegionPrice() > 0.0) {
                    region.setFlag((Flag)DefaultFlag.BUYABLE, (Object)true);
                    region.setFlag((Flag)DefaultFlag.PRICE, (Object)intent.getConfig().getRegionPrice());
                }
                if (intent.getConfig().getPlotType() != null && !intent.getConfig().getPlotType().isEmpty() && this.getPlotSigns() != null) {
                    region.setFlag((Flag)PlotSigns.PLOT_TYPE_FLAG, (Object)intent.getConfig().getPlotType());
                }
                manager.addRegion((ProtectedRegion)region);
                this.getLogger().log(Level.INFO, "Added new region " + regionId + " at " + intent.getMinPoint() + " " + intent.getMaxPoint());
                if (intent.getSign() == null) continue;
                this.registerBuySign(intent);
            }
            this.regionCreatorTask = -1;
        }).getTaskId();
    }

    private void registerBuySign(RegionIntent intent) {
        if (this.getWorldGuard() == null || (this.getRegionConomy() == null || intent.getConfig().getLandPrice() < 0.0) && (this.getPlotSigns() == null || intent.getConfig().getRegionPrice() < 0.0)) {
            return;
        }
        ProtectedRegion region = this.getSimilarRegion(intent, intent.getSign());
        if (region == null) {
            this.getLogger().log(Level.WARNING, "Sign was found at " + intent.getSign() + " but no region?");
            return;
        }
        if (this.getPlotSigns() != null) {
            Block block = intent.getWorld().getBlockAt(intent.getSign().getBlockX(), intent.getSign().getBlockY(), intent.getSign().getBlockZ());
            if (block.getState() instanceof Sign) {
                Sign sign = (Sign)block.getState();
                try {
                    String[] lines = this.getPlotSigns().getSignLines(region);
                    for (int i = 0; i < lines.length; ++i) {
                        sign.setLine(i, lines[i]);
                    }
                    sign.update();
                    this.getLogger().log(Level.INFO, "Wrote PlotSigns sign for region " + intent.getWorld().getName() + "/" + region.getId() + " at " + intent.getSign());
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "Could not create PlotSigns sign! ", e);
                }
            }
        } else if (this.getRegionConomy() != null) {
            this.registerRegionConomySign(region, intent);
        }
    }

    private void registerRegionConomySign(ProtectedRegion region, RegionIntent intent) {
        this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            region.setFlag((Flag)DefaultFlag.BUYABLE, (Object)true);
            this.getRegionConomy().getRegionDatabase().insertRegion(intent.getWorld().getName(), region.getId(), intent.getConfig().getLandPrice());
            if (intent.getConfig().getLandPermission() != null && !intent.getConfig().getLandPermission().isEmpty()) {
                this.getRegionConomy().getRegionDatabase().updatePermission(intent.getWorld().getName(), region.getId(), intent.getConfig().getLandPermission());
            }
            this.getLogger().log(Level.INFO, "Made region " + intent.getWorld().getName() + "/" + region.getId() + " buyable. Price: " + intent.getConfig().getLandPrice() + (intent.getConfig().getLandPermission() != null ? ", permission: " + intent.getConfig().getLandPermission() : ""));
            String[] lines = new String[]{this.getRegionConomy().getConf().getSignSell(), region.getId(), String.valueOf(intent.getConfig().getLandPrice()), intent.getConfig().getLandPermission()};
            this.getServer().getScheduler().runTask((Plugin)this, () -> {
                Block block = intent.getWorld().getBlockAt(intent.getSign().getBlockX(), intent.getSign().getBlockY(), intent.getSign().getBlockZ());
                if (block.getState() instanceof Sign) {
                    Sign sign = (Sign)block.getState();
                    for (int i = 0; i < lines.length; ++i) {
                        sign.setLine(i, lines[i]);
                    }
                    sign.update();
                    this.getLogger().log(Level.INFO, "Wrote MbRegionConomy sign for region " + intent.getWorld().getName() + "/" + region.getId() + " at " + intent.getSign());
                }
            });
        });
    }

    private String getNewRegionId(RegionIntent intent) {
        String regionName;
        RegionManager manager = this.getWorldGuard().getRegionManager(intent.getWorld());
        String mapKey = intent.getWorld().getName() + "_" + intent.getConfig().getRegionId();
        int idNumber = 0;
        if (this.regionIds.containsKey(mapKey)) {
            idNumber = this.regionIds.get(mapKey);
        }
        while (manager.getRegion(regionName = (regionName = intent.getConfig().getRegionId().replace("%world%", intent.getWorld().getName())).contains("%number%") ? regionName.replace("%number%", String.valueOf(idNumber)) : regionName + ++idNumber) != null) {
        }
        this.regionIds.put(mapKey, idNumber);
        return regionName;
    }

    private boolean testForRegion(RegionIntent intent) {
        return this.getSimilarRegion(intent, intent.getMinPoint()) != null || this.getSimilarRegion(intent, intent.getMaxPoint()) != null;
    }

    private ProtectedRegion getSimilarRegion(RegionIntent intent, BlockVector loc) {
        String regionRegexString = intent.getConfig().getRegionId().replace("%world%", "\\w+");
        regionRegexString = regionRegexString.contains("%number%") ? regionRegexString.replace("%number%", "\\d+") : regionRegexString + "\\d+";
        Pattern regionRegex = Pattern.compile("^" + regionRegexString + "$");
        RegionManager manager = this.getWorldGuard().getRegionManager(intent.getWorld());
        ApplicableRegionSet regions = manager.getApplicableRegions((Vector)loc);
        for (ProtectedRegion region : regions) {
            if (!regionRegex.matcher(region.getId()).matches()) continue;
            return region;
        }
        return null;
    }
}

