/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.plotgenerator;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.Vector;
import de.minebench.plotgenerator.PlotGenerator;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;

public class PlotGeneratorConfig {
    private final String id;
    private final CuboidClipboard schematic;
    private final BlockVector center;
    private final int overlap;
    private final String regionId;
    private final int regionInset;
    private final int regionMinY;
    private final int regionMaxY;
    private final double regionPrice;
    private final String plotType;
    private final double landPrice;
    private final String landPermission;

    public PlotGeneratorConfig(String id, CuboidClipboard schematic, BlockVector center, int overlap, String regionId, int regionInset, int regionMinY, int regionMaxY, double regionPrice, String plotType, double landPrice, String landPermission) {
        this.id = id;
        this.schematic = schematic;
        this.center = center;
        this.overlap = overlap;
        this.regionId = regionId;
        this.regionInset = regionInset;
        this.regionMinY = regionMinY;
        this.regionMaxY = regionMaxY;
        this.regionPrice = regionPrice;
        this.plotType = plotType;
        this.landPrice = landPrice;
        this.landPermission = landPermission;
    }

    public static PlotGeneratorConfig fromId(PlotGenerator plugin, String id) {
        String[] args;
        if (id == null || id.isEmpty()) {
            return null;
        }
        Builder b = new Builder(plugin, id);
        for (String arg : args = id.split(",")) {
            if (!arg.contains("=")) {
                b.schematic(arg);
                continue;
            }
            String[] parts = arg.split("=");
            if ("schem".equalsIgnoreCase(parts[0])) {
                b.schematic(parts[1]);
                continue;
            }
            if ("config".equalsIgnoreCase(parts[0])) {
                b.copy(parts[1]);
                continue;
            }
            if ("x".equalsIgnoreCase(parts[0])) {
                try {
                    b.centerX(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse center x coordinates from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("y".equalsIgnoreCase(parts[0])) {
                try {
                    b.centerY(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse center y coordinates from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("z".equalsIgnoreCase(parts[0])) {
                try {
                    b.centerZ(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse center z coordinates from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("overlap".equalsIgnoreCase(parts[0])) {
                try {
                    b.overlap(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse overlap from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("regionId".equalsIgnoreCase(parts[0])) {
                b.regionId(parts[1]);
                continue;
            }
            if ("regionInset".equalsIgnoreCase(parts[0])) {
                try {
                    b.regionInset(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse region inset from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("regionMinY".equalsIgnoreCase(parts[0])) {
                try {
                    b.regionMinY(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse region min y from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("regionMaxY".equalsIgnoreCase(parts[0])) {
                try {
                    b.regionMaxY(Integer.parseInt(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse region max y from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("regionPrice".equalsIgnoreCase(parts[0])) {
                try {
                    b.regionPrice(Double.parseDouble(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse land price from " + parts[1] + "!", e);
                }
                continue;
            }
            if ("plotType".equalsIgnoreCase(parts[0])) {
                b.plotType(parts[1]);
                continue;
            }
            if ("landPrice".equalsIgnoreCase(parts[0])) {
                try {
                    b.landPrice(Double.parseDouble(parts[1]));
                }
                catch (NumberFormatException e) {
                    plugin.getLogger().log(Level.SEVERE, "Can't parse land price from " + parts[1] + "!", e);
                }
                continue;
            }
            if (!"landPermission".equalsIgnoreCase(parts[0])) continue;
            b.landPermission(parts[1]);
        }
        return b.build();
    }

    public static PlotGeneratorConfig fromConfig(PlotGenerator plugin, ConfigurationSection config) {
        if (config == null) {
            return null;
        }
        plugin.getLogger().log(Level.INFO, "Loading config " + config.getName());
        Builder b = new Builder(plugin, config.getName());
        if (config.contains("config")) {
            b.copy(config.getString("config"));
        }
        if (config.contains("schematic")) {
            b.schematic(config.getString("schematic"));
        }
        if (config.contains("center.x")) {
            b.centerX(config.getInt("center.x"));
        }
        if (config.contains("center.y")) {
            b.centerY(config.getInt("center.y"));
        }
        if (config.contains("center.z")) {
            b.centerZ(config.getInt("center.z"));
        }
        if (config.contains("overlap")) {
            b.overlap(config.getInt("overlap"));
        }
        if (config.contains("region.id")) {
            b.regionId(config.getString("region.id"));
        }
        if (config.contains("region.inset")) {
            b.regionInset(config.getInt("region.inset"));
        }
        if (config.contains("region.min-y")) {
            b.regionMinY(config.getInt("region.min-y"));
        }
        if (config.contains("region.max-y")) {
            b.regionMaxY(config.getInt("region.max-y"));
        }
        if (config.contains("region.price")) {
            b.regionPrice(config.getDouble("region.price"));
        }
        if (config.contains("plotsigns.type")) {
            b.plotType(config.getString("plotsigns.type"));
        }
        if (config.contains("land.price")) {
            b.landPrice(config.getDouble("land.price"));
        }
        if (config.contains("land.permission")) {
            b.landPermission(config.getString("land.permission"));
        }
        return b.build();
    }

    public CuboidClipboard getSchematic() {
        return this.schematic;
    }

    public BlockVector getCenter() {
        return this.center;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public int getRegionInset() {
        return this.regionInset;
    }

    public int getRegionMinY() {
        return this.regionMinY;
    }

    public int getRegionMaxY() {
        return this.regionMaxY;
    }

    public double getRegionPrice() {
        return this.regionPrice;
    }

    public String getPlotType() {
        return this.plotType;
    }

    public double getLandPrice() {
        return this.landPrice;
    }

    public String getLandPermission() {
        return this.landPermission;
    }

    public String getId() {
        return this.id;
    }

    public static class Builder {
        private String id;
        private CuboidClipboard schematic = null;
        private Vector center = new Vector(0, 0, 0);
        private int overlap = 0;
        private String regionId = null;
        private int regionInset = 0;
        private int regionMinY = 0;
        private int regionMaxY = 255;
        private double regionPrice = -1.0;
        private String plotType = null;
        private double landPrice = -1.0;
        private String landPermission = null;
        private PlotGenerator plugin;

        public Builder(PlotGenerator plugin, String id) {
            this.plugin = plugin;
            this.id = id;
        }

        public Builder schematic(String name) {
            return this.schematic(name, this.plugin.loadSchematic(name));
        }

        public Builder schematic(String name, CuboidClipboard schematic) {
            if (schematic == null) {
                this.plugin.getLogger().log(Level.WARNING, "Schematic " + name + "not found?");
                return this;
            }
            this.schematic = schematic;
            this.plugin.getLogger().log(Level.INFO, "Schematic: " + name + " (size: " + (schematic == null ? "null" : schematic.getSize()) + ")");
            return this;
        }

        public Builder center(Vector center) {
            this.center = center;
            this.plugin.getLogger().log(Level.INFO, "Center: " + center);
            return this;
        }

        public Builder centerX(double x) {
            this.center = this.center.setX(x);
            this.plugin.getLogger().log(Level.INFO, "Center x: " + x);
            return this;
        }

        public Builder centerY(double y) {
            this.center = this.center.setY(y);
            this.plugin.getLogger().log(Level.INFO, "Center y: " + y);
            return this;
        }

        public Builder centerZ(double z) {
            this.center = this.center.setZ(z);
            this.plugin.getLogger().log(Level.INFO, "Center z: " + z);
            return this;
        }

        public Builder overlap(int overlap) {
            this.overlap = overlap;
            this.plugin.getLogger().log(Level.INFO, "Overlap: " + overlap);
            return this;
        }

        public Builder regionId(String regionId) {
            this.regionId = regionId;
            this.plugin.getLogger().log(Level.INFO, "Region id: " + regionId);
            return this;
        }

        public Builder regionInset(int regionInset) {
            this.regionInset = regionInset;
            this.plugin.getLogger().log(Level.INFO, "Region inset: " + regionInset);
            return this;
        }

        public Builder regionMinY(int regionMinY) {
            this.regionMinY = regionMinY;
            this.plugin.getLogger().log(Level.INFO, "Region min y: " + regionMinY);
            return this;
        }

        public Builder regionMaxY(int regionMaxY) {
            this.regionMaxY = regionMaxY;
            this.plugin.getLogger().log(Level.INFO, "Region max y: " + regionMaxY);
            return this;
        }

        public Builder regionPrice(double regionPrice) {
            this.regionPrice = regionPrice;
            this.plugin.getLogger().log(Level.INFO, "Region price: " + regionPrice);
            return this;
        }

        public Builder plotType(String plotType) {
            this.plotType = plotType;
            this.plugin.getLogger().log(Level.INFO, "PlotSigns plot type: " + plotType);
            return this;
        }

        public Builder landPrice(double landPrice) {
            this.landPrice = landPrice;
            this.plugin.getLogger().log(Level.INFO, "MbRegionConomy land price: " + landPrice);
            return this;
        }

        public Builder landPermission(String landPermission) {
            this.landPermission = landPermission;
            this.plugin.getLogger().log(Level.INFO, "MbRegionConomy land permission: " + landPermission);
            return this;
        }

        public PlotGeneratorConfig build() {
            return new PlotGeneratorConfig(this.id, this.schematic, new BlockVector(this.center), this.overlap, this.regionId, this.regionInset, this.regionMinY, this.regionMaxY, this.regionPrice, this.plotType, this.landPrice, this.landPermission);
        }

        public Builder copy(PlotGeneratorConfig config) {
            this.schematic = config.getSchematic();
            this.center = config.getCenter();
            this.overlap = config.getOverlap();
            this.regionId = config.getRegionId();
            this.regionInset = config.getRegionInset();
            this.regionMinY = config.getRegionMinY();
            this.regionMaxY = config.getRegionMaxY();
            this.regionPrice = config.getRegionPrice();
            this.plotType = config.getPlotType();
            this.landPrice = config.getLandPrice();
            this.landPermission = config.getLandPermission();
            return this;
        }

        public Builder copy(String configName) {
            PlotGeneratorConfig config = this.plugin.getGeneratorConfig(configName);
            if (config != null) {
                this.plugin.getLogger().log(Level.INFO, "Using config " + configName);
                return this.copy(config);
            }
            this.plugin.getLogger().log(Level.WARNING, "Config " + configName + " not found?");
            return this;
        }
    }
}

