/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.plotgenerator.commands;

import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import de.minebench.plotgenerator.PlotGenerator;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BuyPlotCommand
implements CommandExecutor {
    private final PlotGenerator plugin;

    public BuyPlotCommand(PlotGenerator plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be executed by a player!");
            return true;
        }
        if (this.plugin.getWorldGuard() == null) {
            sender.sendMessage(ChatColor.RED + "WorldGuard is not installed!");
            return true;
        }
        if (this.plugin.getEconomy() == null) {
            sender.sendMessage(ChatColor.RED + "Vault is not installed!");
            return true;
        }
        Player player = (Player)sender;
        ProtectedRegion region = null;
        if (args.length > 0) {
            String cmdPerm = command.getPermission();
            command.setPermission(cmdPerm + ".byregionid");
            if (command.testPermission(sender)) {
                ProtectedRegion r = this.plugin.getWorldGuard().getRegionManager(player.getWorld()).getRegion(args[0]);
                if (r == null) {
                    sender.sendMessage(ChatColor.RED + "No region found with the id " + ChatColor.YELLOW + args[0]);
                } else if (r.getFlag((Flag)DefaultFlag.BUYABLE) != null && ((Boolean)r.getFlag((Flag)DefaultFlag.BUYABLE)).booleanValue() && r.getFlag((Flag)DefaultFlag.PRICE) != null && (Double)r.getFlag((Flag)DefaultFlag.PRICE) > 0.0) {
                    region = r;
                } else {
                    sender.sendMessage(ChatColor.RED + "The region " + ChatColor.YELLOW + args[0] + ChatColor.RED + " is not buyable!");
                }
            }
            command.setPermission(cmdPerm);
        } else {
            ApplicableRegionSet regions = this.plugin.getWorldGuard().getRegionManager(player.getWorld()).getApplicableRegions(player.getLocation());
            for (ProtectedRegion r : regions.getRegions()) {
                if (r.getFlag((Flag)DefaultFlag.BUYABLE) == null || !((Boolean)r.getFlag((Flag)DefaultFlag.BUYABLE)).booleanValue() || r.getFlag((Flag)DefaultFlag.PRICE) == null || !((Double)r.getFlag((Flag)DefaultFlag.PRICE) > 0.0)) continue;
                region = r;
            }
            if (region == null) {
                sender.sendMessage(ChatColor.RED + "No buyable region found at your current location!");
            }
        }
        if (region == null) {
            return true;
        }
        double price = (Double)region.getFlag((Flag)DefaultFlag.PRICE);
        EconomyResponse response = this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, price);
        if (response.transactionSuccess()) {
            region.setFlag((Flag)DefaultFlag.BUYABLE, (Object)false);
            region.getOwners().clear();
            region.getOwners().addPlayer(player.getUniqueId());
            region.getMembers().clear();
            sender.sendMessage(ChatColor.GREEN + "You bought the plot " + region.getId() + " for " + price + "!");
        } else {
            sender.sendMessage(ChatColor.RED + "Cannot buy plot! " + response.errorMessage);
        }
        return true;
    }
}

