/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.requiredplugins;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class RequiredPlugins
extends JavaPlugin
implements Listener {
    private Set<String> required;
    private Set<String> missing;
    private boolean kickOnDisable;

    public void onEnable() {
        this.loadConfig();
        this.getCommand("requiredplugins").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.required = new HashSet<String>(this.getConfig().getStringList("required-plugins"));
        this.kickOnDisable = this.getConfig().getBoolean("kick-on-disable");
        this.calculateMissing();
    }

    private void calculateMissing() {
        this.missing = this.required.stream().filter(name -> {
            Plugin p = this.getServer().getPluginManager().getPlugin(name);
            return p == null || !p.isEnabled();
        }).map(String::toLowerCase).collect(Collectors.toSet());
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.missing.remove(event.getPlugin().getName().toLowerCase());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (this.required.contains(event.getPlugin().getName())) {
            this.missing.add(event.getPlugin().getName().toLowerCase());
            this.getLogger().warning(event.getPlugin().getName() + " is a required plugin!");
            for (Player player : this.getServer().getOnlinePlayers()) {
                if (player.hasPermission("requiredplugins.bypasskick")) {
                    player.sendMessage(this.getText("disabled").replace("%plugin%", event.getPlugin().getName()));
                    continue;
                }
                if (!this.kickOnDisable) continue;
                player.kickPlayer(this.getText("kick"));
            }
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (this.missing.size() > 0) {
            if (event.getPlayer().hasPermission("requiredplugins.bypassblock")) {
                this.getServer().getScheduler().runTask((Plugin)this, () -> event.getPlayer().sendMessage(this.getText("join")));
            } else {
                event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
                event.setKickMessage(this.getText("kick"));
            }
        }
    }

    @EventHandler
    public void onServerLoaded(ServerLoadEvent event) {
        this.calculateMissing();
        if (this.missing.size() > 0) {
            this.getLogger().warning("Not all required plugins are loaded: " + this.getPlugins(false));
        }
    }

    private String getText(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("texts." + key, "Unknown text " + key).replace("%plugins%", this.getPlugins(true)).replace("%missing%", this.getPlugins(false)).replace("%missingsize%", String.valueOf(this.missing.size())).replace("%requiredsize%", String.valueOf(this.required.size())));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            if ("reload".equalsIgnoreCase(args[0]) && sender.hasPermission("requiredplugins.command.reload")) {
                this.loadConfig();
                sender.sendMessage(ChatColor.YELLOW + "Config reloaded!");
                return true;
            }
            if ("list".equalsIgnoreCase(args[0]) && sender.hasPermission("requiredplugins.command.list")) {
                sender.sendMessage(ChatColor.RED + "Required Plugins:");
                sender.sendMessage(this.getPlugins(true));
                sender.sendMessage(ChatColor.YELLOW + String.valueOf(this.missing.size()) + ChatColor.RED + "/" + this.required.size() + " missing.");
                return true;
            }
        }
        sender.sendMessage(ChatColor.RED + this.getName() + " " + ChatColor.YELLOW + this.getDescription().getVersion());
        return false;
    }

    private String getPlugins(boolean all) {
        return this.required.stream().sorted(String::compareToIgnoreCase).map(name -> {
            Plugin p = this.getServer().getPluginManager().getPlugin(name);
            if (!all && p != null && p.isEnabled()) {
                return null;
            }
            return p == null ? ChatColor.RED + name : (p.isEnabled() ? ChatColor.GREEN : ChatColor.YELLOW) + p.getName();
        }).filter(Objects::nonNull).collect(Collectors.joining(ChatColor.GRAY + ", "));
    }
}

