/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.tresor.providers.craftconomy3;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.interfaces.BukkitLoader;
import de.minebench.tresor.Provider;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class Craftconomy3Economy
extends Provider<Economy, BukkitLoader>
implements Economy {
    public Craftconomy3Economy() {
        super(Economy.class);
    }

    private Account getAccount(String playerName) {
        return Common.getInstance().getAccountManager().getAccount(playerName, false);
    }

    private Account getAccount(UUID playerId) {
        return Common.getInstance().getStorageHandler().getStorageEngine().getAccount(playerId);
    }

    private String getName(OfflinePlayer offlinePlayer) {
        Account account;
        String name = offlinePlayer.getName();
        if (name == null && (account = this.getAccount(offlinePlayer.getUniqueId())) != null) {
            name = account.getAccountName();
        }
        return name;
    }

    private Currency getCurrency(String worldName) {
        String worldGroupName = Common.getInstance().getWorldGroupManager().getWorldGroupName(worldName);
        Currency currency = null;
        if (!worldGroupName.equals("default")) {
            currency = Common.getInstance().getCurrencyManager().getCurrency(worldGroupName);
        }
        if (currency == null) {
            currency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
        }
        return currency;
    }

    public boolean isEnabled() {
        return Bukkit.getServer().getPluginManager().isPluginEnabled("CraftConomy");
    }

    public BukkitLoader getHooked() {
        return (BukkitLoader)Bukkit.getServer().getPluginManager().getPlugin(this.getName());
    }

    public String getName() {
        return "Craftconomy3";
    }

    public boolean hasBankSupport() {
        return true;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        String worldName = Common.getInstance().getServerCaller().getDefaultWorld();
        Currency defaultCurrency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
        return Common.getInstance().format(worldName, defaultCurrency, amount);
    }

    public String currencyNamePlural() {
        return Common.getInstance().getCurrencyManager().getDefaultCurrency().getPlural();
    }

    public String currencyNameSingular() {
        return Common.getInstance().getCurrencyManager().getDefaultCurrency().getName();
    }

    public boolean hasAccount(String playerName) {
        return playerName != null && Common.getInstance().getAccountManager().exist(playerName, false);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return this.hasAccount(offlinePlayer.getUniqueId());
    }

    public boolean hasAccount(UUID playerId) {
        return this.getAccount(playerId) != null;
    }

    public boolean hasAccount(String playerName, String world) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String world) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String playerName) {
        return this.getBalance(playerName, "default");
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        return this.getBalance(offlinePlayer.getUniqueId(), "default");
    }

    public double getBalance(UUID playerId) {
        return this.getBalance(playerId, "default");
    }

    public double getBalance(String playerName, String worldName) {
        if (!this.hasAccount(playerName)) {
            return 0.0;
        }
        return Common.getInstance().getAccountManager().getAccount(playerName, false).getBalance(worldName, this.getCurrency(worldName).getName());
    }

    public double getBalance(OfflinePlayer offlinePlayer, String worldName) {
        return this.getBalance(offlinePlayer.getUniqueId(), worldName);
    }

    public double getBalance(UUID playerId, String worldName) {
        Account account = this.getAccount(playerId);
        if (account == null) {
            return 0.0;
        }
        return account.getBalance(worldName, this.getCurrency(worldName).getName());
    }

    public boolean has(String playerName, double amount) {
        return this.has(playerName, "default", amount);
    }

    public boolean has(OfflinePlayer offlinePlayer, double amount) {
        return this.has(offlinePlayer, "default", amount);
    }

    public boolean has(UUID playerId, double amount) {
        return this.has(playerId, "default", amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        Account account = this.getAccount(playerName);
        return account != null && account.hasEnough(amount, worldName, this.getCurrency(worldName).getName());
    }

    public boolean has(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.has(offlinePlayer.getUniqueId(), worldName, amount);
    }

    public boolean has(UUID playerId, String worldName, double amount) {
        Account account = this.getAccount(playerId);
        return account != null && account.hasEnough(amount, worldName, this.getCurrency(worldName).getName());
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(playerName, "default", amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double amount) {
        return this.withdrawPlayer(offlinePlayer.getUniqueId(), "default", amount);
    }

    public EconomyResponse withdrawPlayer(UUID playerId, double amount) {
        return this.withdrawPlayer(playerId, "default", amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        Currency currency;
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        Account account = this.getAccount(playerName);
        if (account.hasEnough(amount, worldName, (currency = this.getCurrency(worldName)).getName())) {
            double balance = account.withdraw(amount, worldName, currency.getName(), Cause.VAULT, null);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, this.getBalance(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.withdrawPlayer(offlinePlayer.getUniqueId(), worldName, amount);
    }

    public EconomyResponse withdrawPlayer(UUID playerId, String worldName, double amount) {
        Currency currency;
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        Account account = this.getAccount(playerId);
        if (account.hasEnough(amount, worldName, (currency = this.getCurrency(worldName)).getName())) {
            double balance = account.withdraw(amount, worldName, currency.getName(), Cause.VAULT, null);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, this.getBalance(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(playerName, "default", amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double amount) {
        return this.depositPlayer(offlinePlayer, "default", amount);
    }

    public EconomyResponse depositPlayer(UUID playerId, double amount) {
        return this.depositPlayer(playerId, "default", amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        Account account = this.getAccount(playerName);
        double balance = account.deposit(amount, worldName, this.getCurrency(worldName).getName(), Cause.VAULT, null);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.depositPlayer(offlinePlayer.getUniqueId(), worldName, amount);
    }

    public EconomyResponse depositPlayer(UUID playerId, String worldName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        Account account = this.getAccount(playerId);
        double balance = account.deposit(amount, worldName, this.getCurrency(worldName).getName(), Cause.VAULT, null);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse createBank(String bankName, String playerName) {
        boolean success = false;
        if (!Common.getInstance().getAccountManager().exist(bankName, true)) {
            Common.getInstance().getAccountManager().getAccount(bankName, true).getAccountACL().set(playerName, true, true, true, true, true);
            success = true;
        }
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account. It already exists!");
    }

    public EconomyResponse createBank(String bankName, OfflinePlayer offlinePlayer) {
        return this.createBank(bankName, this.getName(offlinePlayer));
    }

    public EconomyResponse deleteBank(String bankName) {
        boolean success = Common.getInstance().getAccountManager().delete(bankName, true);
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to delete that bank account.");
    }

    public EconomyResponse bankBalance(String bankName) {
        if (Common.getInstance().getAccountManager().exist(bankName, true)) {
            return new EconomyResponse(0.0, Common.getInstance().getAccountManager().getAccount(bankName, true).getBalance("default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName()), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    public EconomyResponse bankHas(String bankName, double amount) {
        if (Common.getInstance().getAccountManager().exist(bankName, true)) {
            Account account = Common.getInstance().getAccountManager().getAccount(bankName, true);
            if (account.hasEnough(amount, Common.getInstance().getServerCaller().getDefaultWorld(), Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName())) {
                return new EconomyResponse(0.0, this.bankBalance((String)bankName).balance, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, this.bankBalance((String)bankName).balance, EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    public EconomyResponse bankWithdraw(String bankName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        EconomyResponse er = this.bankHas(bankName, amount);
        if (!er.transactionSuccess()) {
            return er;
        }
        if (Common.getInstance().getAccountManager().exist(bankName, true)) {
            return new EconomyResponse(0.0, Common.getInstance().getAccountManager().getAccount(bankName, true).withdraw(amount, "default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName(), Cause.VAULT, null), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    public EconomyResponse bankDeposit(String bankName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        if (Common.getInstance().getAccountManager().exist(bankName, true)) {
            return new EconomyResponse(0.0, Common.getInstance().getAccountManager().getAccount(bankName, true).deposit(amount, "default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName(), Cause.VAULT, null), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    public EconomyResponse isBankOwner(String bankName, String playerName) {
        if (Common.getInstance().getAccountManager().exist(bankName, true)) {
            if (Common.getInstance().getAccountManager().getAccount(bankName, true).getAccountACL().isOwner(playerName)) {
                return new EconomyResponse(0.0, this.bankBalance((String)bankName).balance, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "This player is not the owner of the bank!");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
    }

    public EconomyResponse isBankOwner(String bankName, OfflinePlayer offlinePlayer) {
        return this.isBankOwner(bankName, this.getName(offlinePlayer));
    }

    public EconomyResponse isBankMember(String bankName, String playerName) {
        Account account;
        EconomyResponse er = this.isBankOwner(bankName, playerName);
        if (er.transactionSuccess()) {
            return er;
        }
        if (Common.getInstance().getAccountManager().exist(bankName, true) && (account = Common.getInstance().getAccountManager().getAccount(bankName, true)).getAccountACL().canDeposit(playerName) && account.getAccountACL().canWithdraw(playerName)) {
            return new EconomyResponse(0.0, this.bankBalance((String)bankName).balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "This player is not a member of the bank!");
    }

    public EconomyResponse isBankMember(String bankName, OfflinePlayer offlinePlayer) {
        return this.isBankMember(bankName, this.getName(offlinePlayer));
    }

    public List<String> getBanks() {
        return Common.getInstance().getAccountManager().getAllAccounts(true);
    }

    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        Common.getInstance().getAccountManager().getAccount(playerName, false);
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        if (this.hasAccount(offlinePlayer)) {
            return false;
        }
        Account account = Common.getInstance().getAccountManager().getAccount(this.getName(offlinePlayer), false);
        Common.getInstance().getStorageHandler().getStorageEngine().updateUsername(account.getAccountName().toLowerCase(), offlinePlayer.getUniqueId());
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String worldName) {
        return this.createPlayerAccount(offlinePlayer);
    }
}

