/*
 * Decompiled with CFR 0.152.
 */
package de.minebench.tresor.providers.craftconomy3;

import com.greatmancode.craftconomy3.Cause;
import com.greatmancode.craftconomy3.Common;
import com.greatmancode.craftconomy3.account.Account;
import com.greatmancode.craftconomy3.currency.Currency;
import com.greatmancode.craftconomy3.tools.interfaces.BukkitLoader;
import de.minebench.tresor.Provider;
import de.minebench.tresor.TresorUtils;
import de.minebench.tresor.services.economy.EconomyResponse;
import de.minebench.tresor.services.economy.ModernEconomy;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Craftconomy3ModernEconomy
extends Provider<ModernEconomy, BukkitLoader>
implements ModernEconomy {
    private static final BigDecimal ZERO = BigDecimal.ZERO.setScale(128);
    private BukkitLoader hooked;

    public Craftconomy3ModernEconomy() {
        super(ModernEconomy.class);
    }

    private Account getAccount(String playerName) {
        return Common.getInstance().getAccountManager().getAccount(playerName, false);
    }

    private Account getAccount(UUID playerId) {
        return Common.getInstance().getStorageHandler().getStorageEngine().getAccount(playerId);
    }

    private BigDecimal getBalanceInternal(String playerName, String worldName) {
        Account account = this.getAccount(playerName);
        if (account == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(account.getBalance(worldName, this.getCurrency(worldName).getName()));
    }

    private BigDecimal getBalanceInternal(UUID playerId, String worldName) {
        Account account = this.getAccount(playerId);
        if (account == null) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(account.getBalance(worldName, this.getCurrency(worldName).getName()));
    }

    private String getName(OfflinePlayer offlinePlayer) {
        Account account;
        String name = offlinePlayer.getName();
        if (name == null && (account = this.getAccount(offlinePlayer.getUniqueId())) != null) {
            name = account.getAccountName();
        }
        return name;
    }

    private String getName(UUID playerId) {
        Player player = Bukkit.getServer().getPlayer(playerId);
        if (player != null) {
            return player.getName();
        }
        Account account = this.getAccount(playerId);
        if (account != null) {
            return account.getAccountName();
        }
        return null;
    }

    private Currency getCurrency(String worldName) {
        String worldGroupName = Common.getInstance().getWorldGroupManager().getWorldGroupName(worldName);
        Currency currency = null;
        if (!worldGroupName.equals("default")) {
            currency = Common.getInstance().getCurrencyManager().getCurrency(worldGroupName);
        }
        if (currency == null) {
            currency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
        }
        return currency;
    }

    public boolean isEnabled() {
        return this.getHooked() != null ? this.hooked.isEnabled() : Bukkit.getServer().getPluginManager().isPluginEnabled("CraftConomy");
    }

    public BukkitLoader getHooked() {
        if (this.hooked == null) {
            this.hooked = (BukkitLoader)Bukkit.getServer().getPluginManager().getPlugin(this.getName());
        }
        return this.hooked;
    }

    public String getName() {
        return "Craftconomy3";
    }

    public boolean supports(ModernEconomy.Feature feature) {
        switch (feature) {
            case ASYNC: 
            case WORLD: 
            case LOG: 
            case UUID: 
            case OFFLINE: 
            case BANK: {
                return true;
            }
        }
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(BigDecimal amount) {
        String worldName = Common.getInstance().getServerCaller().getDefaultWorld();
        Currency defaultCurrency = Common.getInstance().getCurrencyManager().getDefaultCurrency();
        return Common.getInstance().format(worldName, defaultCurrency, amount.doubleValue());
    }

    public String currencyNamePlural() {
        return Common.getInstance().getCurrencyManager().getDefaultCurrency().getPlural();
    }

    public String currencyNameSingular() {
        return Common.getInstance().getCurrencyManager().getDefaultCurrency().getName();
    }

    public CompletableFuture<Boolean> hasAccount(String playerName) {
        return TresorUtils.asyncFuture(() -> playerName != null && Common.getInstance().getAccountManager().exist(playerName, false));
    }

    public CompletableFuture<Boolean> hasAccount(OfflinePlayer offlinePlayer) {
        return this.hasAccount(offlinePlayer.getUniqueId());
    }

    public CompletableFuture<Boolean> hasAccount(UUID playerId) {
        return TresorUtils.asyncFuture(() -> this.getAccount(playerId) != null);
    }

    public CompletableFuture<Boolean> hasAccount(String playerName, String world) {
        return this.hasAccount(playerName);
    }

    public CompletableFuture<Boolean> hasAccount(UUID playerId, String worldName) {
        return this.hasAccount(playerId);
    }

    public CompletableFuture<Boolean> hasAccount(OfflinePlayer offlinePlayer, String world) {
        return this.hasAccount(offlinePlayer);
    }

    public CompletableFuture<BigDecimal> getBalance(String playerName) {
        return this.getBalance(playerName, "default");
    }

    public CompletableFuture<BigDecimal> getBalance(OfflinePlayer offlinePlayer) {
        return this.getBalance(offlinePlayer.getUniqueId(), "default");
    }

    public CompletableFuture<BigDecimal> getBalance(UUID playerId) {
        return this.getBalance(playerId, "default");
    }

    public CompletableFuture<BigDecimal> getBalance(String playerName, String worldName) {
        return TresorUtils.asyncFuture(() -> this.getBalanceInternal(playerName, worldName));
    }

    public CompletableFuture<BigDecimal> getBalance(OfflinePlayer offlinePlayer, String worldName) {
        return this.getBalance(offlinePlayer.getUniqueId(), worldName);
    }

    public CompletableFuture<BigDecimal> getBalance(UUID playerId, String worldName) {
        return TresorUtils.asyncFuture(() -> {
            Account account = this.getAccount(playerId);
            if (account == null) {
                return ZERO;
            }
            return BigDecimal.valueOf(account.getBalance(worldName, this.getCurrency(worldName).getName()));
        });
    }

    public CompletableFuture<Boolean> has(String playerName, BigDecimal amount) {
        return this.has(playerName, "default", amount);
    }

    public CompletableFuture<Boolean> has(OfflinePlayer offlinePlayer, BigDecimal amount) {
        return this.has(offlinePlayer, "default", amount);
    }

    public CompletableFuture<Boolean> has(UUID playerId, BigDecimal amount) {
        return this.has(playerId, "default", amount);
    }

    public CompletableFuture<Boolean> has(String playerName, String worldName, BigDecimal amount) {
        return TresorUtils.asyncFuture(() -> {
            Account account = this.getAccount(playerName);
            return account != null && account.hasEnough(amount.doubleValue(), worldName, this.getCurrency(worldName).getName());
        });
    }

    public CompletableFuture<Boolean> has(OfflinePlayer offlinePlayer, String worldName, BigDecimal amount) {
        return this.has(offlinePlayer.getUniqueId(), worldName, amount);
    }

    public CompletableFuture<Boolean> has(UUID playerId, String worldName, BigDecimal amount) {
        return TresorUtils.asyncFuture(() -> {
            Account account = this.getAccount(playerId);
            return account != null && account.hasEnough(amount.doubleValue(), worldName, this.getCurrency(worldName).getName());
        });
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(String playerName, BigDecimal amount, String reason) {
        return this.withdrawPlayer(playerName, "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        return this.withdrawPlayer(offlinePlayer.getUniqueId(), "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(UUID playerId, BigDecimal amount, String reason) {
        return this.withdrawPlayer(playerId, "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(String playerName, String worldName, BigDecimal amount, String reason) {
        return TresorUtils.future(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(ZERO, this.getBalanceInternal(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
            }
            Account account = this.getAccount(playerName);
            Currency currency = this.getCurrency(worldName);
            if (account.hasEnough(amount.doubleValue(), worldName, currency.getName())) {
                double balance = account.withdraw(amount.doubleValue(), worldName, currency.getName(), Cause.VAULT, null);
                return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, this.getBalanceInternal(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        });
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(OfflinePlayer offlinePlayer, String worldName, BigDecimal amount, String reason) {
        return this.withdrawPlayer(offlinePlayer.getUniqueId(), worldName, amount, reason);
    }

    public CompletableFuture<EconomyResponse> withdrawPlayer(UUID playerId, String worldName, BigDecimal amount, String reason) {
        return TresorUtils.asyncFuture(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(ZERO, this.getBalanceInternal(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
            }
            Account account = this.getAccount(playerId);
            Currency currency = this.getCurrency(worldName);
            if (account.hasEnough(amount.doubleValue(), worldName, currency.getName())) {
                double balance = account.withdraw(amount.doubleValue(), worldName, currency.getName(), Cause.VAULT, null);
                return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, this.getBalanceInternal(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        });
    }

    public CompletableFuture<EconomyResponse> depositPlayer(String playerName, BigDecimal amount, String reason) {
        return this.depositPlayer(playerName, "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> depositPlayer(OfflinePlayer offlinePlayer, BigDecimal amount, String reason) {
        return this.depositPlayer(offlinePlayer, "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> depositPlayer(UUID playerId, BigDecimal amount, String reason) {
        return this.depositPlayer(playerId, "default", amount, reason);
    }

    public CompletableFuture<EconomyResponse> depositPlayer(String playerName, String worldName, BigDecimal amount, String reason) {
        return TresorUtils.future(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(BigDecimal.ZERO, this.getBalanceInternal(playerName, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
            }
            Account account = this.getAccount(playerName);
            double balance = account.deposit(amount.doubleValue(), worldName, this.getCurrency(worldName).getName(), Cause.VAULT, reason);
            return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, null);
        });
    }

    public CompletableFuture<EconomyResponse> depositPlayer(OfflinePlayer offlinePlayer, String worldName, BigDecimal amount, String reason) {
        return this.depositPlayer(offlinePlayer.getUniqueId(), worldName, amount, reason);
    }

    public CompletableFuture<EconomyResponse> depositPlayer(UUID playerId, String worldName, BigDecimal amount, String reason) {
        return TresorUtils.asyncFuture(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(ZERO, this.getBalanceInternal(playerId, worldName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
            }
            Account account = this.getAccount(playerId);
            double balance = account.deposit(amount.doubleValue(), worldName, this.getCurrency(worldName).getName(), Cause.VAULT, reason);
            return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, null);
        });
    }

    public CompletableFuture<EconomyResponse> createBank(String bankName, String playerName) {
        return TresorUtils.asyncFuture(() -> {
            boolean success = false;
            if (!Common.getInstance().getAccountManager().exist(bankName, true)) {
                Common.getInstance().getAccountManager().getAccount(bankName, true).getAccountACL().set(playerName, true, true, true, true, true);
                success = true;
            }
            if (success) {
                return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account. It already exists!");
        });
    }

    public CompletableFuture<EconomyResponse> createBank(String name, UUID playerId) {
        return null;
    }

    public CompletableFuture<EconomyResponse> createBank(String bankName, OfflinePlayer offlinePlayer) {
        return this.createBank(bankName, this.getName(offlinePlayer));
    }

    public CompletableFuture<EconomyResponse> deleteBank(String bankName) {
        return TresorUtils.asyncFuture(() -> {
            boolean success = Common.getInstance().getAccountManager().delete(bankName, true);
            if (success) {
                return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "Unable to delete that bank account.");
        });
    }

    public CompletableFuture<EconomyResponse> bankBalance(String bankName) {
        return TresorUtils.asyncFuture(() -> {
            if (Common.getInstance().getAccountManager().exist(bankName, true)) {
                double balance = Common.getInstance().getAccountManager().getAccount(bankName, true).getBalance("default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName());
                return new EconomyResponse(ZERO, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        });
    }

    public CompletableFuture<EconomyResponse> bankHas(String bankName, BigDecimal amount) {
        return TresorUtils.asyncFuture(() -> {
            if (Common.getInstance().getAccountManager().exist(bankName, true)) {
                Account account = Common.getInstance().getAccountManager().getAccount(bankName, true);
                if (account.hasEnough(amount.doubleValue(), Common.getInstance().getServerCaller().getDefaultWorld(), Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName())) {
                    return new EconomyResponse(ZERO, this.bankBalance(bankName).get().getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
                }
                return new EconomyResponse(ZERO, this.bankBalance(bankName).get().getBalance(), EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        });
    }

    public CompletableFuture<EconomyResponse> bankWithdraw(String bankName, BigDecimal amount, String reason) {
        return TresorUtils.future(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
            }
            EconomyResponse er = this.bankHas(bankName, amount).get();
            if (!er.transactionSuccess()) {
                return er;
            }
            if (Common.getInstance().getAccountManager().exist(bankName, true)) {
                double balance = Common.getInstance().getAccountManager().getAccount(bankName, true).withdraw(amount.doubleValue(), "default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName(), Cause.VAULT, reason);
                return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        });
    }

    public CompletableFuture<EconomyResponse> bankDeposit(String bankName, BigDecimal amount, String reason) {
        return TresorUtils.future(() -> {
            if (amount.compareTo(ZERO) < 0) {
                return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
            }
            if (Common.getInstance().getAccountManager().exist(bankName, true)) {
                double balance = Common.getInstance().getAccountManager().getAccount(bankName, true).deposit(amount.doubleValue(), "default", Common.getInstance().getCurrencyManager().getDefaultBankCurrency().getName(), Cause.VAULT, reason);
                return new EconomyResponse(amount, BigDecimal.valueOf(balance), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        });
    }

    public CompletableFuture<EconomyResponse> isBankOwner(String bankName, String playerName) {
        return TresorUtils.future(() -> {
            if (Common.getInstance().getAccountManager().exist(bankName, true)) {
                if (Common.getInstance().getAccountManager().getAccount(bankName, true).getAccountACL().isOwner(playerName)) {
                    return new EconomyResponse(ZERO, this.bankBalance(bankName).get().getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
                }
                return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "This player is not the owner of the bank!");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        });
    }

    public CompletableFuture<EconomyResponse> isBankOwner(String bankName, UUID playerId) {
        return this.isBankOwner(bankName, this.getName(playerId));
    }

    public CompletableFuture<EconomyResponse> isBankOwner(String bankName, OfflinePlayer offlinePlayer) {
        return this.isBankOwner(bankName, this.getName(offlinePlayer));
    }

    public CompletableFuture<EconomyResponse> isBankMember(String bankName, String playerName) {
        return TresorUtils.future(() -> {
            Account account;
            EconomyResponse er = this.isBankOwner(bankName, playerName).get();
            if (er.transactionSuccess()) {
                return er;
            }
            if (Common.getInstance().getAccountManager().exist(bankName, true) && (account = Common.getInstance().getAccountManager().getAccount(bankName, true)).getAccountACL().canDeposit(playerName) && account.getAccountACL().canWithdraw(playerName)) {
                return new EconomyResponse(ZERO, this.bankBalance(bankName).get().getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
            }
            return new EconomyResponse(ZERO, ZERO, EconomyResponse.ResponseType.FAILURE, "This player is not a member of the bank!");
        });
    }

    public CompletableFuture<EconomyResponse> isBankMember(String bankName, UUID playerId) {
        return this.isBankMember(bankName, this.getName(playerId));
    }

    public CompletableFuture<EconomyResponse> isBankMember(String bankName, OfflinePlayer offlinePlayer) {
        return this.isBankMember(bankName, this.getName(offlinePlayer));
    }

    public CompletableFuture<List<String>> getBanks() {
        return TresorUtils.asyncFuture(() -> Common.getInstance().getAccountManager().getAllAccounts(true));
    }

    public CompletableFuture<Boolean> createPlayerAccount(String playerName) {
        return TresorUtils.asyncFuture(() -> {
            if (this.hasAccount(playerName).get().booleanValue()) {
                return false;
            }
            Common.getInstance().getAccountManager().getAccount(playerName, false);
            return true;
        });
    }

    public CompletableFuture<Boolean> createPlayerAccount(UUID playerId) {
        return TresorUtils.asyncFuture(() -> {
            if (this.hasAccount(playerId).get().booleanValue()) {
                return false;
            }
            Account account = Common.getInstance().getAccountManager().getAccount(this.getName(playerId), false);
            Common.getInstance().getStorageHandler().getStorageEngine().updateUsername(account.getAccountName().toLowerCase(), playerId);
            return true;
        });
    }

    public CompletableFuture<Boolean> createPlayerAccount(OfflinePlayer offlinePlayer) {
        return TresorUtils.asyncFuture(() -> {
            if (this.hasAccount(offlinePlayer).get().booleanValue()) {
                return false;
            }
            Account account = Common.getInstance().getAccountManager().getAccount(this.getName(offlinePlayer), false);
            Common.getInstance().getStorageHandler().getStorageEngine().updateUsername(account.getAccountName().toLowerCase(), offlinePlayer.getUniqueId());
            return true;
        });
    }

    public CompletableFuture<Boolean> createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public CompletableFuture<Boolean> createPlayerAccount(UUID playerId, String worldName) {
        return this.createPlayerAccount(playerId);
    }

    public CompletableFuture<Boolean> createPlayerAccount(OfflinePlayer offlinePlayer, String worldName) {
        return this.createPlayerAccount(offlinePlayer);
    }
}

